/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.networking.MahouPackets;

public class DoneMentalPacket
implements CustomPacketPayload {
    public static final StreamCodec<ByteBuf, DoneMentalPacket> STREAM_CODEC = StreamCodec.unit((Object)new DoneMentalPacket());

    public static void handle(DoneMentalPacket message, IPayloadContext context) {
        DoneMentalPacket.onMessage(message, context.player());
    }

    public static void onMessage(DoneMentalPacket message, Player player) {
        if (player != null) {
            int range = MTConfig.MENTAL_DISPLACEMENT_RANGE * 3;
            Vec3 post = player.position().add(new Vec3((double)range, (double)range, (double)range));
            Vec3 posb = player.position().add(new Vec3((double)(-range), (double)(-range), (double)(-range)));
            List lst = player.level().getEntitiesOfClass(MentalDisplacementEntity.class, new AABB(posb.x, posb.y, posb.z, post.x, post.y, post.z));
            for (MentalDisplacementEntity e : lst) {
                if (e.player != null && !e.player.getUUID().equals(player.getUUID())) continue;
                e.discard();
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof DoneMentalPacket;
    }

    public CustomPacketPayload.Type<DoneMentalPacket> type() {
        return MahouPackets.DONE_MENTAL_TYPE;
    }
}

