/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.WallStickPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityJumpPacket
implements CustomPacketPayload {
    double lookX;
    double lookY;
    double lookZ;
    long held;
    public static final StreamCodec<ByteBuf, AuthorityJumpPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, p -> p.lookX, (StreamCodec)ByteBufCodecs.DOUBLE, p -> p.lookY, (StreamCodec)ByteBufCodecs.DOUBLE, p -> p.lookZ, (StreamCodec)ByteBufCodecs.VAR_LONG, p -> p.held, AuthorityJumpPacket::new);

    public AuthorityJumpPacket(double x, double y, double z, long h) {
        this.lookX = x;
        this.lookY = y;
        this.lookZ = z;
        this.held = h;
    }

    public static void handle(AuthorityJumpPacket message, IPayloadContext context) {
        AuthorityJumpPacket.authorityJump(message, (ServerPlayer)context.player());
    }

    public static void authorityJump(AuthorityJumpPacket packet, ServerPlayer player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY) && WallStickPotion.onWallOrGround((LivingEntity)player)) {
            AuthorityJumpPacket.boop((Entity)player, Math.min((float)packet.held / 4.0f, 5.0f), -packet.lookX, -packet.lookY, -packet.lookZ);
            EffectUtil.buff((LivingEntity)player, ModEffects.AUTHORITY_JUMP, false, 900, false);
        }
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        entity.hurtMarked = true;
        entity.setDeltaMovement(new Vec3(motionX -= x / (double)f * (double)strength, motionY -= y / (double)f * (double)strength, motionZ -= z / (double)f * (double)strength));
    }

    public CustomPacketPayload.Type<AuthorityJumpPacket> type() {
        return MahouPackets.AUTHORITY_JUMP_TYPE;
    }
}

