/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.william;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.io.FileUtils;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.william.DictionarySearcher;

public class DictionaryDownloader {
    public static Thread dictionaryDownloader;
    public String url;
    private File cacheFile;
    public static HashMap<String, Dictionary> dictionaries;
    public static HashMap<String, List<Consumer<DictionarySearcher>>> consumers;
    public ServerLevel level;

    public DictionaryDownloader(String url) {
        this.url = url;
    }

    public static boolean allDictionariesFinished() {
        boolean ret = !dictionaries.keySet().isEmpty();
        for (String s : dictionaries.keySet()) {
            ret = ret && DictionaryDownloader.dictionaries.get((Object)s).complete;
        }
        return ret;
    }

    public static void startAllDownloaders(Consumer<DictionarySearcher> consumer) {
        for (String string : MTConfig.WILLIAM_DICTIONARIES) {
            DictionaryDownloader.startDictionaryDownloader(string, consumer);
        }
    }

    public static void startDictionaryDownloader(String s, Consumer<DictionarySearcher> consumer) {
        Object url = "https://raw.githubusercontent.com/stepsword/all-words-in-all-languages/refs/heads/main/" + s + "/" + s + ".txt";
        if (s.startsWith("https://")) {
            url = s;
        }
        DictionaryDownloader dd = new DictionaryDownloader(s);
        dd.cacheFile = new File("mahoutsukai/" + s + ".txt");
        dd.getDictionary((String)url, consumer);
    }

    public void getDictionary(final String url, final Consumer<DictionarySearcher> consumer) {
        if (dictionaries.containsKey(url) && DictionaryDownloader.dictionaries.get((Object)url).complete) {
            consumer.accept(DictionaryDownloader.dictionaries.get((Object)url).dictionary);
        } else if (dictionaries.containsKey(url) && !DictionaryDownloader.dictionaries.get((Object)url).complete) {
            if (consumers.containsKey(url)) {
                consumers.get(url).add(consumer);
            } else {
                consumers.put(url, new ArrayList<Consumer<DictionarySearcher>>(List.of(consumer)));
            }
        } else {
            dictionaries.put(url, new Dictionary(this, null, false));
            dictionaryDownloader = new Thread("Mahou Dictionary Downloader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        if (!DictionaryDownloader.this.cacheFile.exists()) {
                            httpurlconnection = (HttpURLConnection)new URI(url).toURL().openConnection();
                            httpurlconnection.setDoInput(true);
                            httpurlconnection.setRequestProperty("Accept", "text/*");
                            httpurlconnection.setDoOutput(false);
                            httpurlconnection.connect();
                            if (httpurlconnection.getResponseCode() / 100 == 2) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DictionaryDownloader.this.cacheFile);
                            }
                        }
                        FileInputStream inputstream = new FileInputStream(DictionaryDownloader.this.cacheFile);
                        String largeDictionary = new String(((InputStream)inputstream).readAllBytes(), StandardCharsets.UTF_8);
                        DictionarySearcher ds = DictionarySearcher.initializeDictionarySearcher(largeDictionary);
                        dictionaries.put(url, new Dictionary(DictionaryDownloader.this, ds, true));
                        consumer.accept(ds);
                        if (consumers.containsKey(url)) {
                            for (Consumer<DictionarySearcher> cons : consumers.get(url)) {
                                cons.accept(ds);
                            }
                        }
                    }
                    catch (Exception exception) {
                        MahouTsukaiMod.logger.error("Couldn't download dictionary", (Throwable)exception);
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            dictionaryDownloader.start();
        }
    }

    static {
        dictionaries = new HashMap();
        consumers = new HashMap();
    }

    public class Dictionary {
        DictionarySearcher dictionary = null;
        boolean complete = false;

        public Dictionary(DictionaryDownloader this$0, DictionarySearcher d, boolean c) {
            this.dictionary = d;
            this.complete = c;
        }
    }
}

