/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.kodoku;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.kodoku.KodokuMahou;
import stepsword.mahoutsukai.entity.kodoku.KodokuEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class KodokuItem
extends ItemBase {
    public KodokuItem() {
        super(new Item.Properties().component(DataComponents.KODOKU_COMPONENT, (Object)new KodokuMahou(0)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        KodokuMahou kodokuMahou;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Item item = stack.getItem();
        if (item instanceof KodokuItem && (kodokuMahou = Utils.getKodokuMahou(stack)) != null) {
            String kodoku = "" + kodokuMahou.getKodoku();
            tooltip.add((Component)Component.literal((String)(Component.translatable((String)"mahoutsukai.kodoku").getString() + ": " + kodoku)));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Direction facing = context.getClickedFace();
        if (!worldIn.isClientSide) {
            KodokuItem.setKodoku(player.getMainHandItem(), KodokuItem.getKodoku(player.getMainHandItem()));
            KodokuEntity entity = new KodokuEntity(worldIn);
            Vec3 place = EffectUtil.fromBlockPos(pos.relative(facing));
            entity.absMoveTo(place.x + 0.5 + Math.random() * 0.3, place.y, place.z + 0.5 + Math.random() * 0.3, (float)(Math.random() * 360.0), 0.0f);
            entity.kodoku = KodokuItem.getKodoku(player.getItemInHand(hand));
            worldIn.addFreshEntity((Entity)entity);
            player.getItemInHand(hand).shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!target.level().isClientSide) {
            int kodoku = KodokuItem.getKodoku(playerIn.getItemInHand(hand));
            boolean hasworm = false;
            for (int i = 0; i < target.getPassengers().size(); ++i) {
                if (!(target.getPassengers().get(i) instanceof KodokuEntity)) continue;
                hasworm = true;
            }
            if (kodoku <= 0 && !(target instanceof KodokuEntity) && !hasworm) {
                KodokuEntity entity = new KodokuEntity(target.level());
                entity.absMoveTo(target.getX() - (double)(target.getDimensions(Pose.STANDING).width() / 2.0f), target.getY() + (double)target.getEyeHeight(), target.getZ(), target.yRot, target.xRot + 90.0f);
                target.level().addFreshEntity((Entity)entity);
                entity.startRiding((Entity)target, true);
                playerIn.getItemInHand(hand).shrink(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static int getKodoku(ItemStack stack) {
        KodokuMahou mahou = Utils.getKodokuMahou(stack);
        return mahou.getKodoku();
    }

    public static void setKodoku(ItemStack stack, int k) {
        KodokuMahou mahou = Utils.getKodokuMahou(stack);
        mahou.setKodoku(k);
        Utils.setKodokuMahou(stack, mahou);
    }
}

