/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GrowSwordItem
extends SwordItem {
    public GrowSwordItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties.component((DataComponentType)DataComponents.SWORD_COMPONENT.value(), (Object)new SwordMahou(3.0f, 10000.0)));
    }

    public GrowSwordItem(Tier pTier, float aspd, int admg, int dura) {
        super(pTier, new Item.Properties().attributes(GrowSwordItem.createAttributes(admg, aspd)).durability(dura).component((DataComponentType)DataComponents.SWORD_COMPONENT.value(), (Object)new SwordMahou(admg, 10000.0)));
    }

    public float getAttack(ItemStack stack) {
        if (stack != null) {
            SwordMahou mahou = Utils.getSwordMahou(stack);
            return mahou.getAttackDamage();
        }
        return 3.0f;
    }

    public float getCappedAttack(ItemStack stack) {
        SwordMahou sm;
        if (stack != null && (sm = Utils.getSwordMahou(stack)) != null) {
            float damage = sm.getAttackDamage();
            double cap = sm.getInnateCap();
            if (MTConfig.POWER_CONSOLIDATION_TIERS.isEmpty()) {
                float capped = Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, damage);
                sm.setAttackDamage(capped);
                Utils.setSwordMahou(stack, sm);
                return capped;
            }
            float capped = (float)Math.min((double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, cap);
            sm.setInnateCap(capped);
            capped = (float)Math.min(sm.getInnateCap(), (double)damage);
            sm.setAttackDamage(capped);
            Utils.setSwordMahou(stack, sm);
            return capped;
        }
        return 3.0f;
    }

    public static void adjustAttributeModifiers(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof GrowSwordItem) {
            float damage = ((GrowSwordItem)stack.getItem()).getAttack(stack);
            if (stack.getItem() instanceof Caliburn || stack.getItem() instanceof Morgan) {
                damage = ((GrowSwordItem)stack.getItem()).getCappedAttack(stack);
            }
            event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }

    public static ItemAttributeModifiers createAttributes(int pAttackDamage, float pAttackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)pAttackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)pAttackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if ((ModItems.morgan.get() == stack.getItem() || ModItems.caliburn.get() == stack.getItem()) && EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    public static void anvilNoRepair(AnvilUpdateEvent event) {
        if (event.getLeft().getItem() == ModItems.morgan.get() && event.getRight().getItem() == ModItems.morgan.get()) {
            event.setCanceled(true);
        }
        if (event.getLeft().getItem() == ModItems.caliburn.get() && event.getRight().getItem() == ModItems.caliburn.get()) {
            event.setCanceled(true);
        }
    }
}

