/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.handlers;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.VanillaGameEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.entity.player.TradeWithVillagerEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.FogProjector;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.commands.ModCommands;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.effects.Kodoku;
import stepsword.mahoutsukai.effects.displacement.EquivalentDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProjectileDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProtectiveDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.exchange.DamageExchangeSpellEffect;
import stepsword.mahoutsukai.effects.familiar.FamiliarsGardenEffect;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.effects.mystic.DamageReplicationSpellEffect;
import stepsword.mahoutsukai.effects.mystic.RhoAiasSpellEffect;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.MorganEffect;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.WilliamEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.item.GrowSwordItem;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.nobu.Nobu;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.item.rulebreaker.RuleBreaker;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.item.william.William;
import stepsword.mahoutsukai.mana.ManaEvents;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.TurnedPagePacket;
import stepsword.mahoutsukai.potion.ActingPotion;
import stepsword.mahoutsukai.potion.AuthorityJumpPotion;
import stepsword.mahoutsukai.potion.BindingEyesPotion;
import stepsword.mahoutsukai.potion.BlackFlameEyesPotion;
import stepsword.mahoutsukai.potion.BorrowedAuthorityPotion;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ConfusionPotion;
import stepsword.mahoutsukai.potion.DeathCollectionEyesPotion;
import stepsword.mahoutsukai.potion.ExtraPotionInterface;
import stepsword.mahoutsukai.potion.FaySightEyesPotion;
import stepsword.mahoutsukai.potion.FearPotion;
import stepsword.mahoutsukai.potion.FlungPotion;
import stepsword.mahoutsukai.potion.ForesightPotion;
import stepsword.mahoutsukai.potion.ImmunityExchangePotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.potion.WallStickPotion;
import stepsword.mahoutsukai.potion.WoundedPotion;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.MahouJobs;

public class ServerHandler {
    public static long tickCounter = 0L;

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void tickCheck(PlayerTickEvent.Post event) {
        if (tickCounter % 10L == 0L && !event.getEntity().level().isClientSide) {
            InsightEyesPotion.insightEyesPlayerTick(event.getEntity());
            BorrowedAuthorityPotion.authorityPlayerTick(event.getEntity());
            BindingEyesPotion.bindingEyesPlayerTick(event.getEntity());
            ReversionEyesPotion.reversionEyesPlayerTick(event.getEntity());
            ClairvoyanceEyesPotion.clairvoyanceEyesPlayerTick(event.getEntity());
            FearPotion.fearPlayerTick(event.getEntity());
            MorganEffect.secretCalibur(event.getEntity());
            William.createWilliamCheck(event.getEntity());
        }
        if (tickCounter % 100L == 0L && !event.getEntity().level().isClientSide) {
            PlayerManaManager.regenMana(event.getEntity(), false);
            MahouSettings.updateClientMahou((ServerPlayer)event.getEntity());
        }
        if (tickCounter % 4L == 0L && !event.getEntity().level().isClientSide) {
            FaySightEyesPotion.faySightEyesPlayerTick(event.getEntity());
        }
        if (tickCounter % (long)MTConfig.BLACK_FLAME_IGNITION_TICKS == 0L && !event.getEntity().level().isClientSide) {
            BlackFlameEyesPotion.blackFlameEyesPlayerTick(event.getEntity());
        }
        if (tickCounter % (long)MTConfig.NOBU_SPAWN_AND_FIRE_FREQ == 0L && !event.getEntity().level().isClientSide) {
            Nobu.nobuPlayerTick(event);
        }
        if (tickCounter % 100L == 0L && !(event.getEntity().getUseItem().getItem() instanceof MysticStaff)) {
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
    }

    @SubscribeEvent
    public void attributeModifiers(ItemAttributeModifierEvent event) {
        GrowSwordItem.adjustAttributeModifiers(event);
        TheRipper.adjustAttributeModifiers(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(LevelTickEvent.Post event) {
        PowerConsolidationSpellEffect.powerConsolidationWorldTick(event);
        MurkyWaterBlock.murkyUpdateTick(event);
        FogProjector.fogUpdateTick(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide) {
            tickCounter = event.getLevel().getGameTime() % 50000L;
        }
    }

    @SubscribeEvent
    public void livingEvent(EntityTickEvent.Pre event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            ServerHandler.cancelEvent((Event)event, BindingEyesPotion.bindingEyesLivingUpdate(entity));
            BorrowedAuthorityPotion.authorityLivingUpdate(entity);
            ReversionEyesPotion.reversionEyesLivingUpdate(entity);
            BlackFlameEyesPotion.blackFlameEyesLivingUpdate(entity);
            FearPotion.fearLivingUpdate(entity);
            MentalDisplacementSpellEffect.mentalDisplacementLivingUpdate((Entity)entity);
            FamiliarsGardenEffect.familiarsGardenLivingUpdate(entity);
            MisfortunePotion.misfortuneLivingUpdate(entity);
            ConfusionPotion.confusionLivingUpdate(entity);
            WoundedPotion.woundedLivingTick(entity);
            TheRipper.ripperLivingTick(entity);
            RipperInvisPotion.presenceConcealmentLivingTick(entity);
            AuthorityJumpPotion.authorityJumpLivingTick(entity);
            FlungPotion.flungLivingTick(entity);
            ProbabilityAlterPotion.applyProbabilityAlter(entity);
            WallStickPotion.wallStickLivingTick(entity);
        }
    }

    @SubscribeEvent
    public void attackFromPlayer(AttackEntityEvent event) {
        Caliburn.upgradeDamageCap(event);
        boolean canceled = BoundPotion.boundAttackFromPlayer(event.getEntity()) || FamiliarsGardenEffect.familiarsGardenAttackEntity(event.getTarget(), event.getEntity()) || GeasEffect.geasAttackEntity(event);
        ServerHandler.cancelEvent((Event)event, canceled);
        ServerHandler.cancelEvent((Event)event, canceled);
        if (!canceled) {
            BorrowedAuthorityPotion.authorityAttackFromPlayer(event.getEntity(), event.getTarget());
            StaffEmrys.emrysHit(event);
        }
    }

    @SubscribeEvent
    public void struckByLightning(EntityStruckByLightningEvent event) {
        StaffEmrys.emrysStruckByLightning(event);
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundLeftClickBlock(event.getEntity()));
        PowerConsolidationSpellEffect.caliburnLeftClickBlock(event);
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        ForesightPotion.butterflyPlaceBlock(event);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        MahoujinProjector.shiftRCBlock(event);
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickBlock(event.getEntity()));
        ManaEvents.rightClickCircle(event.getEntity(), event.getPos());
        EquivalentDisplacementSpellEffect.equivalentDisplacementShiftRightClick(event);
        William.createWilliam(event);
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickItem(event.getEntity()));
        ClarentEffect.clarentOnRightClick(event.getEntity());
        TurnedPagePacket.openedBook(event);
    }

    @SubscribeEvent
    public void tradeVillager(TradeWithVillagerEvent event) {
        William.williamBookTraded(event);
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent event) {
        boolean z = ReversionEyesPotion.reversionEyesProjectileImpact(event.getEntity(), event.getRayTraceResult());
        ServerHandler.cancelEvent((Event)event, z);
        if (!z) {
            ServerHandler.cancelEvent((Event)event, ProtectiveDisplacementSpellEffect.protectiveDisplacementProjectileImpact(event));
        }
    }

    @SubscribeEvent
    public void potionAdded(MobEffectEvent.Added event) {
        DamageReplicationSpellEffect.damageReplicationPotionAdded(event);
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() instanceof ExtraPotionInterface) {
            ((ExtraPotionInterface)event.getEffectInstance().getEffect().value()).onAdd(event.getEntity(), (MobEffect)event.getEffectInstance().getEffect().value());
        }
    }

    @SubscribeEvent
    public void potionFinish(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null) {
            if (event.getEffect().value() instanceof ExtraPotionInterface) {
                ((ExtraPotionInterface)event.getEffect().value()).onRemove(event.getEntity(), (MobEffect)event.getEffect().value());
            }
            MisfortunePotion.kodokuPotionRemove(event);
        }
    }

    @SubscribeEvent
    public void potionFinish(MobEffectEvent.Expired event) {
        Object object;
        if (event.getEffectInstance() != null && (object = event.getEffectInstance().getEffect().value()) instanceof ExtraPotionInterface) {
            ExtraPotionInterface ef = (ExtraPotionInterface)object;
            ef.onRemove(event.getEntity(), (MobEffect)event.getEffectInstance().getEffect().value());
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ReversionEyesPotion.notifyIfReverted(living);
            BlackFlameEyesPotion.notifyIfBurning(living);
            RipperInvisPotion.notifyIfInvisible(living);
            ActingPotion.notifyIfActing(living);
        }
    }

    @SubscribeEvent
    public void livingUse(LivingEntityUseItemEvent.Stop event) {
        StrengtheningSpellEffect.strengtheningUseEvent(event);
    }

    @SubscribeEvent
    public void livingUse(UseItemOnBlockEvent event) {
        StrengtheningSpellEffect.strengtheningUseEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingDeath(LivingDeathEvent event) {
        boolean cancels = DeathCollectionEyesPotion.deathCollectionEyesLivingDeath(event.getEntity(), event.getSource());
        ServerHandler.cancelEvent((Event)event, cancels);
        DamageReplicationSpellEffect.damageReplicationLivingDeath((Entity)event.getEntity());
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        MorganEffect.morganLivingDeath(event);
        Kodoku.kodokuEntityDeath(event);
        PlayerManaManager.playerDeath(event);
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingIncomingDamageEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void highPriorityLivingHurt(LivingIncomingDamageEvent event) {
        boolean cancels = ImmunityExchangePotion.immunityExchangeLivingHurt(event) || GeasEffect.geasLivingHurt(event) || Replica.replicaLivingHurt(event) || FamiliarsGardenEffect.familiarsGardenLivingDamage(event);
        ServerHandler.cancelEvent((Event)event, cancels);
    }

    @SubscribeEvent
    public void livingAttack(LivingIncomingDamageEvent event) {
        ClarentEffect.clarentLivingAttack(event);
        Replica.replicaLivingAttack(event);
        StrengtheningSpellEffect.strengtheningArmorEvent(event);
        Nobu.nobuCreate(event);
        DamageReplicationSpellEffect.damageReplicationLivingDamage(event);
        ContractMahoujinTileEntity.breakContract(event);
        if (!event.isCanceled()) {
            StrengtheningSpellEffect.strengtheningLivingHurt(event);
            RealityMarbleSpellEffect.realityMarbleLivingHurt((Entity)event.getEntity());
            ManaEvents.manaPlayerHurt(event.getEntity(), event.getAmount());
            StaffEmrys.emrysLivingHurt(event);
            ClarentEffect.clarentLivingHurt(event);
            RhongomyniadEntity.rhongomyniadLivingHurt(event);
            TheRipper.ripperOnHit(event);
            DamageExchangeSpellEffect.damageExchangeLivingHurt(event);
            RuleBreaker.ruleBreakerLivingHurt(event);
        }
    }

    @SubscribeEvent
    public void anvilRepair(AnvilRepairEvent event) {
        ProjectionSpellEffect.projectionRepairAnvil(event);
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        ProjectionSpellEffect.projectionUpdateAnvil(event);
        Morgan.anvilNoRepair(event);
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        StrengtheningSpellEffect.strengtheningHarvestCheck(event);
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        StrengtheningSpellEffect.strengtheningBreakEvent(event);
        MisfortunePotion.misfortuneBreakEvent(event);
        ForesightPotion.butterflyBreakBlock(event);
        Replica.replicaBreakBlock(event);
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        StrengtheningSpellEffect.strengtheningBreakSpeed(event);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        RealityMarbleSpellEffect.realityMarbleChunkUnload(event);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        RealityMarbleSpellEffect.realityMarbleChunkLoad(event);
        PowerConsolidationSpellEffect.powerConsolidationChunkLoad(event);
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        ServerHandler.cancelEvent((Event)event, RealityMarbleSpellEffect.realityMarbleLivingFall(event));
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinLevelEvent event) {
        ProjectileDisplacementSpellEffect.projectileDisplacementJoinWorld(event.getEntity());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Start event) {
        FamiliarsGardenEffect.familiarsGardenExplosion(event.getExplosion().getIndirectSourceEntity());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Detonate event) {
        RhoAiasSpellEffect.rhoAiasExplosionProtection(event);
        Replica.replicaExplosionProtection(event);
    }

    @SubscribeEvent
    public void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        SummonFamiliarSpellEffect.familiarRightClick(event);
        RhongomyniadEntity.rhongomyniadRightClick(event);
        WilliamEntity.williamRightClick(event);
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Finish event) {
        ManaEvents.drinkMilk(event);
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent event) {
    }

    @SubscribeEvent
    public void useItem(ItemEntityPickupEvent.Pre event) {
        if (GeasEffect.geasItem(event)) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        ManaEvents.mahouClone(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ManaEvents.mahouLogin(event.getEntity());
    }

    @SubscribeEvent
    public void playerSlept(PlayerWakeUpEvent event) {
        if (!event.wakeImmediately() && !event.updateLevel()) {
            ManaEvents.mahouSleep(event.getEntity());
        }
    }

    @SubscribeEvent
    public void setTargetEvent(LivingChangeTargetEvent event) {
        ServerHandler.cancelEvent((Event)event, FearPotion.fearLivingSetAttack(event.getEntity(), event.getNewAboutToBeSetTarget()));
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        MisfortunePotion.misfortuneLootEvent(event);
    }

    @SubscribeEvent
    public void vanillaGameEvent(VanillaGameEvent event) {
        ServerHandler.cancelEvent((Event)event, RipperInvisPotion.presenceConcealmentNoSound(event));
    }

    @SubscribeEvent(receiveCanceled=true)
    public void serverTick(ServerTickEvent.Pre event) {
        MahouJobs.runJobs();
    }

    public static void cancelEvent(Event e, boolean c) {
        if (e instanceof ICancellableEvent) {
            ICancellableEvent cancelable = (ICancellableEvent)e;
            if (!((ICancellableEvent)e).isCanceled()) {
                ((ICancellableEvent)e).setCanceled(c);
            }
        }
    }
}

