/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.item.nobu.Nobu;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GunEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_SIZE = "MAHOUTSUKAI_SZ";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A2 = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PITCH_COOLDOWN = SynchedEntityData.defineId(GunEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float startYaw = 0.0f;
    public float startPitch = 0.0f;
    public GunBeamProjectileEntity mybeam = null;
    public Vec3 startVelocity = new Vec3(0.0, 0.0, 0.0);
    public UUID casterUUID = null;
    public int recoilingTicks = 0;
    public int recoveryTicks = 0;
    public float goalPitch = 0.0f;
    public int sound = 0;
    public Vec3 targetPos = null;
    public boolean autonomous = false;
    public int autonomousLife = 0;

    public GunEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GunEntity(Level world) {
        super((EntityType)ModEntities.GUN_ENTITY.get(), world);
        this.noCulling = true;
    }

    public GunEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.getUUID();
    }

    public GunEntity(Level world, Player caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this(world);
        this.startPitch = caster.xRot;
        this.startYaw = caster.yRot;
        this.startVelocity = caster.getViewVector(1.0f);
        this.casterUUID = caster.getUUID();
        this.setColor(r, g, b, a, r2, g2, b2, a2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A2, (Object)Float.valueOf(1.0f));
        builder.define(SHOOTING_TICKS, (Object)-1);
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
        builder.define(TARGET, (Object)0);
        builder.define(PITCH_COOLDOWN, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            this.pitchCD();
            this.aimassist();
            this.firing();
            this.seppuku();
            this.teleportTo(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
        }
    }

    public void adjustPitch(boolean up) {
        this.goalPitch = (float)(!up ? -MTConfig.NOBU_PITCH_INCREMENT : MTConfig.NOBU_PITCH_INCREMENT);
        this.setPitchCooldown((int)MTConfig.NOBU_PITCH_INCREMENT);
    }

    public void pitchCD() {
        float TIME_PER_DEGREE = (float)MTConfig.NOBU_ADJUSTMENT_TICKS_PER_DEGREE;
        float speed = 1.0f / TIME_PER_DEGREE;
        int p = this.getPitchCooldown();
        if (p > 0) {
            this.setPitchCooldown(p - 1);
        }
        if (this.goalPitch > speed) {
            this.goalPitch -= speed;
            this.setRotationPitch(this.getRotationPitch() - 1.0f / TIME_PER_DEGREE);
        } else if (this.goalPitch < -speed) {
            this.goalPitch += speed;
            this.setRotationPitch(this.getRotationPitch() + 1.0f / TIME_PER_DEGREE);
        }
    }

    public void firing() {
        if (this.recoilingTicks == 0) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.recoilingTicks > 0) {
            --this.recoilingTicks;
            if (this.targetPos == null) {
                this.moveAlongAxisNoTarget(-1.0);
            } else {
                this.moveAlongAxis(-1.0);
            }
            if (this.recoilingTicks == 0) {
                this.recoveryTicks = 10 * MTConfig.NOBU_RECOIL_TIME;
            }
        } else if (this.recoveryTicks > 0) {
            --this.recoveryTicks;
            if (this.targetPos == null) {
                this.moveAlongAxisNoTarget(0.1);
            } else {
                this.moveAlongAxis(0.1);
            }
        } else if (!(this.getLife() < 10 || this.mybeam != null && this.mybeam.isAlive())) {
            this.spawnBeam();
        }
        if (this.mybeam != null && !this.mybeam.getFired()) {
            this.moveAimBeam(this.mybeam);
        }
    }

    public void aimassist() {
        Entity target = null;
        if (this.getTarget() > 0) {
            target = this.level().getEntity(this.getTarget());
        }
        if (target != null) {
            this.targetPos = target.getEyePosition();
            this.aimAt(this.targetPos);
        }
    }

    public void seppuku() {
        Player caster = this.getCaster();
        if (caster == null) {
            this.discard();
            return;
        }
        if (!this.autonomous) {
            if (!(caster.getUseItem().getItem() instanceof Nobu) || Utils.getMode(caster.getUseItem()) == 0) {
                this.discard();
            }
        } else {
            this.autonomousLife = !(caster.getUseItem().getItem() instanceof Nobu) || Utils.getMode(caster.getUseItem()) == 0 ? ++this.autonomousLife : 0;
            if (this.autonomousLife > MTConfig.NOBU_AUTONOMOUS_LIFE_TICKS) {
                this.discard();
                if (Nobu.player_storage.containsKey(this.casterUUID)) {
                    Nobu.player_storage.get((Object)this.casterUUID).guns.values().remove((Object)this);
                }
            }
        }
        if (Nobu.player_storage.containsKey(this.casterUUID)) {
            Nobu.NobuUserStorage storage = Nobu.player_storage.get(this.casterUUID);
            if (!storage.guns.containsValue((Object)this)) {
                this.discard();
            }
        } else {
            this.discard();
        }
    }

    public Player getCaster() {
        if (this.casterUUID != null) {
            return this.level().getPlayerByUUID(this.casterUUID);
        }
        return null;
    }

    public void spawnBeam() {
        Player player = this.getCaster();
        if (player != null) {
            Vec3 spawn = this.position();
            float[] colors = Nobu.getColor(player, 0);
            GunBeamProjectileEntity beam = new GunBeamProjectileEntity(this.level(), this.casterUUID, colors[0], colors[1], colors[2], 0.6f, colors[3], colors[4], colors[5], 1.0f, 0.15f, 0.0f, this.getTarget());
            beam.setPos(spawn);
            if (this.targetPos != null) {
                beam.aimAt(this.targetPos);
            } else {
                beam.setRotationPitch(this.getRotationPitch() + 90.0f);
                beam.setRotationYaw(-this.getRotationYaw());
            }
            this.level().addFreshEntity((Entity)beam);
            this.mybeam = beam;
            beam.autonomous = true;
            beam.owner = this;
        }
    }

    public void moveAimBeam(GunBeamProjectileEntity beam) {
        Vec3 spawn = this.position();
        beam.setPos(spawn);
        if (this.targetPos != null) {
            beam.aimAt(this.targetPos);
        } else {
            beam.setRotationPitch(this.getRotationPitch() + 90.0f);
            beam.setRotationYaw(-this.getRotationYaw());
        }
    }

    public void fireSound(int n) {
        SoundEvent sound = (SoundEvent)ModSounds.TAIKOBIG.get();
        if (n == 0) {
            sound = (SoundEvent)ModSounds.TAIKO1.get();
        }
        if (n == 1) {
            sound = (SoundEvent)ModSounds.TAIKO2.get();
        }
        if (n == 2) {
            sound = (SoundEvent)ModSounds.TAIKO3.get();
        }
        this.level().playSound(null, Utils.toBlockPos(this.position()), sound, SoundSource.NEUTRAL, (float)MTConfig.NOBU_DRUM_VOLUME, 1.0f);
    }

    public void fireBeam() {
        if (Nobu.doShotMana(this.getCaster()) && this.mybeam != null && this.recoilingTicks <= 0 && this.recoveryTicks <= 0) {
            this.recoilingTicks = MTConfig.NOBU_RECOIL_TIME;
            this.fireSound(this.sound);
            if (!this.mybeam.getFired()) {
                MandatoryFun.completeFunReq(this.getCaster(), MandatoryFun.FUN_REQS.NOBU_FIRE_SQUAD);
                Vec3 spawn = this.mybeam.position();
                this.mybeam.setFired(true);
                Entity target = this.level().getEntity(this.getTarget());
                if (target != null) {
                    Vec3 targetPos = target.getEyePosition();
                    Vec3 aim = targetPos.subtract(spawn).normalize();
                    this.mybeam.setDeltaMovement(aim.x * 5.0, aim.y * 5.0, aim.z * 5.0);
                    this.mybeam.aimAt(targetPos);
                } else {
                    Vec3 aim = Utils.vecFromPitchYaw(-this.getRotationPitch() + 180.0f, -this.getRotationYaw()).normalize();
                    this.mybeam.setDeltaMovement(aim.x * 5.0, aim.y * 5.0, aim.z * 5.0);
                    this.mybeam.setRotationPitch(EffectUtil.toDegrees((float)(-Math.atan2(Math.sqrt(aim.z * aim.z + aim.x * aim.x), aim.y))));
                    this.mybeam.setRotationYaw(-EffectUtil.toDegrees((float)Math.atan2(aim.z, aim.x)) + 270.0f);
                }
                this.mybeam = null;
            }
        }
    }

    public void moveAlongAxisNoTarget(double scale) {
        this.setDeltaMovement(Utils.vecFromPitchYaw(-this.getRotationPitch() + 180.0f, -this.getRotationYaw()).normalize().scale(scale));
    }

    public void moveAlongAxis(double scale) {
        this.setDeltaMovement(this.position().subtract(this.targetPos).normalize().scale(-scale));
    }

    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public void aimAt(Vec3 pos) {
        Vec3 aim = pos.subtract(this.position());
        this.setRotationPitch(EffectUtil.toDegrees((float)Math.atan2(Math.sqrt(aim.z * aim.z + aim.x * aim.x), aim.y)) + 270.0f);
        this.setRotationYaw(-EffectUtil.toDegrees((float)Math.atan2(aim.z, aim.x)) + 270.0f);
        this.setRotationRoll(90.0f);
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue(), ((Float)this.entityData.get(COLOR_A2)).floatValue()};
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.getFloat(TAG_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        if (compound.hasUUID(TAG_CASTER)) {
            this.casterUUID = compound.getUUID(TAG_CASTER);
        }
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2), compound.getFloat(TAG_COLOR_A2));
        this.setShootingTicks(compound.getInt(TAG_SHOOTING_TICKS));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.putFloat(TAG_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.casterUUID);
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_COLOR_A2, colors[7]);
        compound.putInt(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.putFloat(TAG_DISTANCE, this.getDistance());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public int getShootingTicks() {
        return (Integer)this.entityData.get(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.entityData.set(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }

    public int getTarget() {
        return (Integer)this.entityData.get(TARGET);
    }

    public void setTarget(int d) {
        this.entityData.set(TARGET, (Object)d);
    }

    public int getPitchCooldown() {
        return (Integer)this.entityData.get(PITCH_COOLDOWN);
    }

    public void setPitchCooldown(int d) {
        this.entityData.set(PITCH_COOLDOWN, (Object)d);
    }
}

