/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GandrEntity
extends Entity {
    public static final String entityName = "gandr_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public ArrayList<MobEffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int swirls = 100;
    public float[] progressstarts = new float[this.swirls];
    public float[] progressends = new float[this.swirls];
    public float[] angles = new float[this.swirls];
    public boolean inited = false;
    public float swirlLife = 9.0f;
    public int firedProgressLife = 3;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public GandrEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GandrEntity(Level world) {
        super((EntityType)ModEntities.GANDR.get(), world);
        this.noCulling = true;
    }

    public GandrEntity(Level world, LivingEntity caster, float r, float g, float b, float a, float r2, float g2, float b2) {
        this(world);
        this.setCasterUUID(caster.getUUID());
        this.setColor(r, g, b, a, r2, g2, b2);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue()};
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(FIRED, (Object)false);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLife(compound.getInt(TAG_LIFE));
        this.setFired(compound.getBoolean(TAG_FIRED));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putBoolean(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
    }

    public float getGrowingLife() {
        return 15.0f;
    }

    public void tick() {
        Player player;
        if (this.timeCreated == -1L) {
            this.timeCreated = this.level().getGameTime();
        }
        this.setLife(this.getLife() + 1);
        if (this.level().isClientSide) {
            if (!this.inited) {
                for (int i = 0; i < this.swirls; ++i) {
                    this.progressstarts[i] = (float)i * 1.0f / (float)this.swirls;
                    this.progressends[i] = this.progressstarts[i] + this.swirlLife / 100.0f;
                    this.angles[i] = this.random.nextFloat() * 360.0f;
                    if (!(this.progressends[i] > 1.0f)) continue;
                    int n = i;
                    this.progressends[n] = this.progressends[n] - 1.0f;
                }
                this.inited = true;
            }
        } else {
            if (this.ticksSinceFired > 800 || this.level().getGameTime() - this.timeCreated > 6000L) {
                this.discard();
            }
            if (this.getCasterUUID() == null) {
                this.discard();
            } else {
                Player player2 = this.level().getPlayerByUUID(this.getCasterUUID());
                if (!(this.getFired() || player2 != null && (player2.getUseItem().getItem() instanceof GandrSpellScroll || player2.getUseItem().getItem() instanceof MysticCode))) {
                    this.discard();
                }
            }
        }
        if (this.getFired()) {
            ++this.ticksSinceFired;
            if (this.level().isClientSide) {
                MahouTsukaiMod.proxy.spawnGandrParticle(this);
            } else {
                this.checkHit();
            }
        }
        if (this.getCasterUUID() != null && !this.getFired() && (player = this.level().getPlayerByUUID(this.getCasterUUID())) != null) {
            this.setLookPos(player.level().isClientSide, (LivingEntity)player, this);
        }
        this.teleportTo(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
    }

    public void checkHit() {
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d2 = this.position();
        Vec3 vec3d3 = vec3d2.add(vec3d);
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(vec3d2, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vec3d3 = raytraceresult.getLocation();
        }
        while (!this.isRemoved()) {
            EntityHitResult entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.ENTITY && raytraceresult instanceof EntityHitResult) {
                Entity entity = ((EntityHitResult)raytraceresult).getEntity();
                Entity entity1 = this.getShooter();
                if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
                this.onHit((HitResult)raytraceresult);
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
    }

    public void onHit(HitResult result) {
        Vec3 look = this.getViewVector(1.0f);
        int black_particles = MTConfig.GANDR_BLACK_PARTICLES_HIT;
        int red_particles = MTConfig.GANDR_RED_PARTICLES_HIT;
        float radius = (float)MTConfig.GANDR_HIT_RADIUS;
        int duration = MTConfig.GANDR_CLOUD_DURATION;
        AreaEffectCloud area = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        boolean spawn = false;
        if (this.getShooter() instanceof LivingEntity) {
            area.setRadius(radius);
            area.setOwner((LivingEntity)this.getShooter());
            area.setDuration(duration);
            for (MobEffectInstance e : this.effects) {
                if (!GandrEntity.validEffect(e, this.getShooter().level())) continue;
                spawn = true;
                area.addEffect(e);
            }
        }
        if (spawn) {
            this.level().addFreshEntity((Entity)area);
        }
        AABB aabb = new AABB(this.getX() - (double)radius, this.getY() - (double)radius, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + (double)radius, this.getZ() + (double)radius);
        List entities = this.level().getEntities(this.getShooter(), aabb, Entity::isAlive);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), entity)) continue;
            EffectUtil.magicAttack((LivingEntity)entity, this.damage, (LivingEntity)this.level().getPlayerByUUID(this.getCasterUUID()));
            if (entity.isAlive() && !(((LivingEntity)entity).getHealth() <= 0.0f) || !(this.getShooter() instanceof ServerPlayer)) continue;
            ((MahouTrigger)((Object)ModTriggers.GANDR.get())).trigger((ServerPlayer)this.getShooter());
        }
        float[] rgbs = this.getColor();
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.getX(), this.getY(), this.getZ(), look.x, look.y, look.z, 2.0, 1, 1, black_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.getX(), this.getY(), this.getZ(), look.x, look.y, look.z, 2.0, 0, 1, red_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        this.discard();
    }

    public static boolean validEffect(MobEffectInstance e, Level level) {
        Holder effect = e.getEffect();
        boolean inwhitelist = false;
        for (String string : MTConfig.GANDR_EFFECT_WHITELIST) {
            if (!string.equals(Utils.getRegistryName((MobEffect)e.getEffect().value(), level))) continue;
            inwhitelist = true;
        }
        boolean inblacklist = false;
        for (String string : MTConfig.GANDR_EFFECT_BLACKLIST) {
            if (!string.equals(Utils.getRegistryName((MobEffect)e.getEffect().value(), level))) continue;
            inblacklist = true;
        }
        return inwhitelist || !inblacklist && ((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.level() instanceof ServerLevel ? ((ServerLevel)this.level()).getEntity(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_213871_1_ -> !p_213871_1_.isSpectator() && p_213871_1_.isAlive() && p_213871_1_.isPickable() && (!p_213871_1_.getUUID().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public Vec3 setLookPos(boolean client, LivingEntity caster, GandrEntity gandr) {
        Vec3 look = caster.getViewVector(1.0f);
        Vec3 oldlook = look.normalize();
        look = oldlook.scale((double)1.1f);
        Vec3 start = look.add(caster.getEyePosition(1.0f));
        gandr.yRot = caster.yRot;
        gandr.xRot = caster.xRot;
        if (!client) {
            gandr.setPos(start.x, start.y, start.z);
        }
        return start;
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.entityData.get(FIRED);
    }

    public void setFired(boolean f) {
        this.entityData.set(FIRED, (Object)f);
    }
}

