/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.entity.ModEntities;

public class AuthorityMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_LOOK_VEC = "MAHOUTSUKAI_LOOK_VEC";
    public static final int loadUpTime = 20;
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<CompoundTag> LOOK_VEC = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(AuthorityMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int casterUUID = 0;
    public static final String entityName = "authority_mahoujin_entity";

    public AuthorityMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public AuthorityMahoujinEntity(Level world) {
        super((EntityType)ModEntities.AUTHORITY.get(), world);
        this.noCulling = true;
    }

    public AuthorityMahoujinEntity(Level world, LivingEntity caster) {
        this(world);
        this.casterUUID = caster.getId();
    }

    public AuthorityMahoujinEntity(Level world, LivingEntity caster, float r, float g, float b, float a, float size) {
        this(world);
        this.casterUUID = caster.getId();
        this.setColor(r, g, b, a);
        this.angleForPlayer(caster);
        this.sizer(size);
    }

    public AuthorityMahoujinEntity(Level world, LivingEntity caster, Vec3 look, Vec3 eyes, float r, float g, float b, float a, float size) {
        this(world);
        this.casterUUID = caster.getId();
        this.setColor(r, g, b, a);
        this.angleForPlayer2(look, eyes);
        this.sizer(size);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
        builder.define(LOOK_VEC, (Object)new CompoundTag());
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            Entity caster = this.level().getEntity(this.casterUUID);
            if (caster == null || !caster.isAlive()) {
                this.discard();
            }
            if (this.getLife() >= 20) {
                this.discard();
            }
        }
    }

    public boolean isPickable() {
        return false;
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void angleForPlayer(LivingEntity user) {
        Vec3 lookVec = user.getDeltaMovement();
        Vec3 vec = lookVec.normalize();
        this.setLookV(lookVec.normalize());
        Vec3 eyes = user.getEyePosition(1.0f);
        this.setPos(eyes.x, eyes.y, eyes.z);
        double theta = Math.asin(vec.y);
        theta = AuthorityMahoujinEntity.fromRad(theta);
        double theta2 = Math.atan2(vec.x, vec.z);
        theta2 = AuthorityMahoujinEntity.fromRad(theta2);
        this.setRotationRoll((float)theta2);
        this.setRotationPitch((float)(360.0 - (theta + 90.0)));
    }

    public void angleForPlayer2(Vec3 lookVec, Vec3 eyes) {
        Vec3 vec = lookVec.normalize();
        this.setLookV(lookVec.normalize());
        this.setPos(eyes.x, eyes.y, eyes.z);
        double theta = Math.asin(vec.y);
        theta = AuthorityMahoujinEntity.fromRad(theta);
        double theta2 = Math.atan2(vec.x, vec.z);
        theta2 = AuthorityMahoujinEntity.fromRad(theta2);
        this.setRotationRoll((float)theta2);
        this.setRotationPitch((float)(theta + 90.0));
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static double fromRad(double rad) {
        return rad * 57.2957795131;
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
        CompoundTag look = compound.getCompound(TAG_LOOK_VEC);
        this.setLookV(new Vec3(look.getDouble("x"), look.getDouble("y"), look.getDouble("z")));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_DISTANCE, this.getDistance());
        Vec3 look = this.getLookV();
        CompoundTag looknbt = new CompoundTag();
        looknbt.putDouble("x", look.x);
        looknbt.putDouble("y", look.y);
        looknbt.putDouble("z", look.z);
        compound.put(TAG_LOOK_VEC, (Tag)looknbt);
    }

    public Vec3 rotateAroundOrigin(Vec3 pos, float pitch, float roll, float yaw) {
        Vec3 rho = this.position();
        return rho.add(pos.subtract(rho).yRot(roll).xRot(pitch).yRot(yaw));
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }

    public Vec3 getLookV() {
        CompoundTag nbt = (CompoundTag)this.entityData.get(LOOK_VEC);
        return new Vec3(nbt.getDouble("x"), nbt.getDouble("y"), nbt.getDouble("z"));
    }

    public void setLookV(Vec3 v) {
        if (v != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("x", v.x);
            nbt.putDouble("y", v.y);
            nbt.putDouble("z", v.z);
            this.entityData.set(LOOK_VEC, (Object)nbt);
        }
    }
}

