/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeAIFollow
extends Goal {
    private final PathfinderMob entity;
    private final Predicate<LivingEntity> followPredicate;
    private LivingEntity followingEntity;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float fard;
    private final float neard;
    private float oldWaterCost;
    private final float areaSize;
    private int timeFollowing;

    public FaeAIFollow(final PathfinderMob e, double speed, float far, float area, float near) {
        this.entity = e;
        this.followPredicate = new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity r) {
                return r != null && e != r;
            }
        };
        this.speedModifier = speed;
        this.navigation = e.getNavigation();
        this.fard = far;
        this.neard = near;
        this.areaSize = area;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List list;
        if ((this.followingEntity == null || Math.random() > 0.05) && !(list = this.entity.level().getEntitiesOfClass(LivingEntity.class, this.entity.getBoundingBox().inflate((double)this.areaSize), this.followPredicate)).isEmpty()) {
            for (LivingEntity creature : list) {
                if (creature.isInvisible()) continue;
                if (!(creature instanceof Player) || EffectUtil.hasBuff(creature, ModEffects.FAY_SIGHT_EYES)) {
                    this.followingEntity = creature;
                }
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.followingEntity != null && !this.navigation.isDone() && this.entity.distanceToSqr((Entity)this.followingEntity) < (double)(this.fard * this.fard);
    }

    public void start() {
        this.timeFollowing = 0;
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.timeFollowing = 0;
        this.followingEntity = null;
        this.navigation.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        if (this.followingEntity != null && !this.entity.isLeashed()) {
            ++this.timeFollowing;
            Vec3 motion = this.entity.getDeltaMovement();
            double motionX = motion.x;
            double motionY = motion.y;
            double motionZ = motion.z;
            this.entity.getLookControl().setLookAt((Entity)this.followingEntity, 10.0f, (float)this.entity.getMaxHeadXRot());
            float f = 0.01f;
            if (!Utils.isBlockAir(this.entity.level(), this.entity.blockPosition().below()) || Math.random() > 0.6) {
                // empty if block
            }
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = 1;
                double d0 = this.entity.getX() - this.followingEntity.getX();
                double d3 = d0 * d0 + (d1 = 0.0) * d1 + (d2 = this.entity.getZ() - this.followingEntity.getZ()) * d2;
                if (d3 < (double)(this.fard * this.fard)) {
                    Vec3 toFollowing = new Vec3(-d0, -d1, -d2).normalize().scale(10.0);
                    float reachfactor = 0.01f;
                    if (d3 < (double)(this.neard * this.neard)) {
                        toFollowing = toFollowing.yRot(org.joml.Math.toRadians((float)90.0f));
                        motionX = toFollowing.x * 0.03;
                        motionZ = toFollowing.z * 0.03;
                        toFollowing = toFollowing.yRot(org.joml.Math.toRadians((float)-90.0f));
                        motionX += (motionX - toFollowing.x) * (double)reachfactor;
                        motionZ += (motionZ - toFollowing.z) * (double)reachfactor;
                    } else {
                        motionX -= (motionX - toFollowing.x) * (double)reachfactor;
                        motionZ -= (motionZ - toFollowing.z) * (double)reachfactor;
                    }
                } else {
                    this.navigation.stop();
                }
            }
            this.entity.setDeltaMovement(motionX, motionY, motionZ);
        }
        if (this.timeFollowing > 200) {
            this.followingEntity = null;
        }
    }
}

