/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.butterfly;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SerializableHit {
    public ItemStack stack;
    public ItemStack offstack;
    public Vec3 knockback;
    public Vec3 initialPosition;
    public List<MobEffectInstance> effects;
    public float knockbackStrength;
    public int fire;
    public float cooled;
    public float rotyaw;
    public float rotpit;

    public CompoundTag write(Level level) {
        CompoundTag ret = new CompoundTag();
        if (this.stack != null && !this.stack.isEmpty()) {
            ret.put("stack", this.stack.save((HolderLookup.Provider)level.registryAccess(), (Tag)new CompoundTag()));
        }
        if (this.offstack != null && !this.offstack.isEmpty()) {
            ret.put("offstack", this.offstack.save((HolderLookup.Provider)level.registryAccess(), (Tag)new CompoundTag()));
        }
        if (this.knockback != null) {
            ret.putDouble("kx", this.knockback.x());
            ret.putDouble("ky", this.knockback.y());
            ret.putDouble("kz", this.knockback.z());
        }
        if (this.initialPosition != null) {
            ret.putDouble("ipx", this.initialPosition.x());
            ret.putDouble("ipy", this.initialPosition.y());
            ret.putDouble("ipz", this.initialPosition.z());
        }
        if (this.effects != null) {
            for (int i = 0; i < this.effects.size(); ++i) {
                MobEffectInstance e = this.effects.get(i);
                ret.put("effect" + i, e.save());
            }
        }
        ret.putFloat("knockstrength", this.knockbackStrength);
        ret.putFloat("cooled", this.cooled);
        ret.putFloat("rotyaw", this.rotyaw);
        ret.putFloat("rotpit", this.rotpit);
        ret.putInt("fire", this.fire);
        return ret;
    }

    public void read(CompoundTag nbt, Level level) {
        if (nbt.contains("stack")) {
            this.stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)nbt.getCompound("stack")).orElse(new ItemStack((ItemLike)Items.WOODEN_SWORD));
        }
        if (nbt.contains("offstack")) {
            this.offstack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)nbt.getCompound("offstack")).orElse(new ItemStack((ItemLike)Items.WOODEN_SWORD));
        }
        if (nbt.contains("kx") && nbt.contains("ky") && nbt.contains("kz")) {
            this.knockback = new Vec3(nbt.getDouble("kx"), nbt.getDouble("ky"), nbt.getDouble("kz"));
        }
        if (nbt.contains("ipx") && nbt.contains("ipy") && nbt.contains("ipz")) {
            this.initialPosition = new Vec3(nbt.getDouble("ipx"), nbt.getDouble("ipy"), nbt.getDouble("ipz"));
        }
        this.effects = new ArrayList<MobEffectInstance>();
        int i = 0;
        while (nbt.contains("effect" + i)) {
            MobEffectInstance effect = MobEffectInstance.load((CompoundTag)nbt.getCompound("effect" + i));
            this.effects.add(effect);
            ++i;
        }
        this.knockbackStrength = nbt.getFloat("knockstrength");
        this.cooled = nbt.getFloat("cooled");
        this.rotyaw = nbt.getFloat("rotyaw");
        this.rotpit = nbt.getFloat("rotpit");
        this.fire = nbt.getInt("fire");
    }
}

