/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FamiliarEntity
extends ShoulderRidingEntity
implements FlyingAnimal {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public static final int exploreRadius = 5;
    SitWhenOrderedToGoal sitGoal;
    private UUID familiarId = null;
    public int r;
    public int g;
    public int b;
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_GARDEN_TICKS = "MAHOUTSUKAI_GARDEN_TICKS";
    private static final String TAG_HOLIDAY = "MAHOUTSUKAI_HOLIDAY";
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> HOLIDAY = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GARDEN_TICKS = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private String searchBlock = null;
    public static final String entityName = "familiar_entity";
    TicketType<ChunkPos> ticket = null;
    BlockPos lastInteresting = null;

    public FamiliarEntity(Level worldIn) {
        super((EntityType)ModEntities.FAMILIAR.get(), worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPersistenceRequired();
    }

    public FamiliarEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void registerGoals() {
        this.sitGoal = new SitWhenOrderedToGoal((TamableAnimal)this);
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)this.sitGoal);
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (double)MTConfig.FAMILIAR_HEALTH).add(Attributes.FLYING_SPEED, (double)0.8f).add(Attributes.MOVEMENT_SPEED, (double)0.4f);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.setCanOpenDoors(true);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
        if (!this.level().isClientSide) {
            this.updateMap();
            this.loadChunks();
            this.reportSurroundings();
            this.gardenUpdate();
        }
    }

    public void activateGarden() {
        int gardenTime = 1200;
        this.setGardenTicks(gardenTime);
        this.acknowledge();
    }

    public void acknowledge() {
        if (this.getOwner() != null) {
            int z = this.getRandom().nextInt(4) + 1;
            MutableComponent s = Component.translatable((String)("mahoutsukai.acknowledge" + z));
            if (this.getOwner() instanceof Player) {
                ((Player)this.getOwner()).displayClientMessage((Component)Component.literal((String)(this.getMyName() + ": " + s.getString())).withStyle(ChatFormatting.AQUA), MTConfig.FAMILIAR_ACTION_BAR_MESSAGES);
            }
        }
    }

    public void gardenUpdate() {
        float blue;
        float green;
        float red;
        int gardenTime = MTConfig.FAMILIARS_GARDEN_TIME;
        int tick = this.getGardenTicks();
        int startup = 20;
        float colorRatio = 1.0f;
        float gr = 232.0f;
        float gg = 86.0f;
        float gb = 186.0f;
        float nr = 91.0f;
        float ng = 209.0f;
        float nb = 252.0f;
        if (this.getHoliday()) {
            float[] fs = this.holidayToColor();
            nr = fs[0];
            ng = fs[1];
            nb = fs[2];
        }
        if (tick > 0) {
            if (tick < startup) {
                colorRatio = (float)tick / (float)startup;
            }
            if (tick > gardenTime - startup) {
                colorRatio = (float)(gardenTime - tick) / (float)startup;
            }
            red = (gr - nr) * colorRatio + nr;
            green = (gg - ng) * colorRatio + ng;
            blue = (gb - nb) * colorRatio + nb;
            if (tick % 100 == 0) {
                this.gardenEffectA();
            }
            this.setGardenTicks(tick - 1);
        } else {
            red = nr;
            green = ng;
            blue = nb;
        }
        if (tick < 0) {
            this.setGardenTicks(0);
        }
        this.setColor(red / 255.0f, green / 255.0f, blue / 255.0f);
    }

    public void gardenEffectA() {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        List nearby = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.getX() - (double)range, this.getY() - (double)range, this.getZ() - (double)range, this.getX() + (double)range, this.getY() + (double)range, this.getZ() + (double)range));
        for (Player Player2 : this.level().players()) {
            if (!(Player2.distanceToSqr(this.position()) < 16384.0)) continue;
            PacketHandler.sendTo((ServerPlayer)Player2, new GardenPacket(this.getX(), this.getY(), this.getZ()));
        }
        for (LivingEntity entity : nearby) {
            EffectUtil.buff(entity, ModEffects.PEACEFUL_GARDEN, false, 120);
        }
    }

    public static void gardenEffectB(BlockPos pos, Level world) {
        int range = MTConfig.FAMILIARS_GARDEN_RANGE;
        Stream lst = BlockPos.betweenClosedStream((BlockPos)pos.offset(range, range / 2, range), (BlockPos)pos.offset(-range, -range / 2, -range));
        lst.forEach(p -> {
            if (Utils.isBlockAir(world, pos)) {
                float x = p.getX();
                float y = p.getY();
                float z = p.getZ();
                RandomSource random = world.random;
                double d = pos.distSqr((Vec3i)p);
                double rat = d / ((double)range * (double)range);
                if (rat > 1.0) {
                    rat = 1.0;
                }
                float lessenPetals = 0.4f;
                if (random != null) {
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.addParticle((ParticleOptions)ModParticles.PETAL.get(), (double)x + 0.2, (double)y + 0.2, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.addParticle((ParticleOptions)ModParticles.PETAL.get(), (double)x + 0.8, (double)y + 0.2, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.addParticle((ParticleOptions)ModParticles.PETAL.get(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.addParticle((ParticleOptions)ModParticles.PETAL.get(), (double)x + 0.2, (double)y + 0.8, (double)z + 0.8, 0.0, 0.0, 0.0);
                    }
                    if (random.nextDouble() > rat && random.nextDouble() > (double)lessenPetals) {
                        world.addParticle((ParticleOptions)ModParticles.PETAL.get(), (double)x + 0.8, (double)y + 0.8, (double)z + 0.2, 0.0, 0.0, 0.0);
                    }
                }
            }
        });
    }

    public int getGardenTicks() {
        return (Integer)this.entityData.get(GARDEN_TICKS);
    }

    public void setGardenTicks(int t) {
        this.entityData.set(GARDEN_TICKS, (Object)t);
    }

    public void toggleHoliday() {
        this.setHoliday(!this.getHoliday());
    }

    public void setHoliday(boolean h) {
        this.entityData.set(HOLIDAY, (Object)h);
    }

    public boolean getHoliday() {
        return (Boolean)this.entityData.get(HOLIDAY);
    }

    public void setSearchBlock(String s) {
        this.searchBlock = s;
    }

    public String getSearchBlock() {
        return this.searchBlock;
    }

    public float[] holidayToColor() {
        float[] ret = new float[3];
        if (this.whichHoliday() == 1) {
            ret[0] = 51.0f;
            ret[1] = 204.0f;
            ret[2] = 51.0f;
        } else if (this.whichHoliday() == 2) {
            ret[0] = 140.0f;
            ret[1] = 0.0f;
            ret[2] = 255.0f;
        } else if (this.whichHoliday() == 3) {
            ret[0] = 23.0f;
            ret[1] = 209.0f;
            ret[2] = 54.0f;
        } else if (this.whichHoliday() == 4) {
            ret[0] = 255.0f;
            ret[1] = 91.0f;
            ret[2] = 25.0f;
        } else {
            ret[0] = 91.0f;
            ret[1] = 209.0f;
            ret[2] = 252.0f;
        }
        return ret;
    }

    public int whichHoliday() {
        if (Calendar.getInstance().get(2) == 11) {
            return 1;
        }
        if (Calendar.getInstance().get(2) == 1) {
            return 2;
        }
        if (Calendar.getInstance().get(2) == 2) {
            return 3;
        }
        if (Calendar.getInstance().get(2) == 9) {
            return 4;
        }
        return 0;
    }

    public void updateMap() {
        if (this.getOwner() != null) {
            if (SummonFamiliarSpellEffect.familiarMap.containsKey(this.getOwnerUUID())) {
                FamiliarEntity e = SummonFamiliarSpellEffect.familiarMap.get(this.getOwnerUUID());
                if (e != null && e.getFamiliarId() != null && e.getFamiliarId().equals(this.getFamiliarId())) {
                    if (!e.isAlive()) {
                        SummonFamiliarSpellEffect.familiarMap.put(this.getOwnerUUID(), this);
                    } else if (e != this) {
                        this.discard();
                    }
                } else {
                    this.discard();
                }
            } else {
                this.discard();
            }
        }
    }

    public void reportSurroundings() {
        Player owner;
        if (ServerHandler.tickCounter % (long)MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME == 0L && !this.level().isClientSide && (owner = (Player)this.getOwner()) != null) {
            List players;
            AABB aabb = new AABB(this.blockPosition().offset(-5, -5, -5).getCenter(), this.blockPosition().offset(5, 5, 5).getCenter());
            MutableComponent toSend = null;
            RandomSource rand = owner.getRandom();
            if (rand.nextBoolean() && !(players = this.level().getEntitiesOfClass(Player.class, aabb)).isEmpty()) {
                toSend = this.reportPlayer((Player)players.get(rand.nextInt(players.size())), owner);
            }
            if (toSend == null) {
                List things;
                if (rand.nextBoolean() && !(things = this.level().getEntitiesOfClass(LivingEntity.class, aabb)).isEmpty()) {
                    toSend = this.reportEntity((LivingEntity)things.get(rand.nextInt(things.size())), owner);
                }
                if (toSend == null) {
                    ArrayList blocks = new ArrayList();
                    Stream lst = BlockPos.betweenClosedStream((int)((int)this.getX() - 5), (int)((int)this.getY() - 5), (int)((int)this.getZ() - 5), (int)((int)this.getX() + 5), (int)((int)this.getY() + 5), (int)((int)this.getZ() + 5));
                    lst.forEach(tmp -> {
                        BlockState bt = this.level().getBlockState(tmp);
                        if (this.getSearchBlock() == null) {
                            if (this.isInterestingBlock(bt.getBlock())) {
                                blocks.add(new BlockPos(tmp.getX(), tmp.getY(), tmp.getZ()));
                            }
                        } else if (Utils.getRegistryName(bt.getBlock(), this.level()).equals(this.getSearchBlock())) {
                            blocks.add(new BlockPos(tmp.getX(), tmp.getY(), tmp.getZ()));
                        }
                    });
                    if (!blocks.isEmpty()) {
                        IMahou mahou;
                        this.lastInteresting = (BlockPos)blocks.get(rand.nextInt(blocks.size()));
                        if (this.getOwner() instanceof Player && (mahou = Utils.getPlayerMahou((Player)this.getOwner())) != null) {
                            mahou.setFamiliarInterestingBlock(this.lastInteresting);
                            EffectUtil.buff(this.getOwner(), ModEffects.INTERESTING_BLOCK, false, MTConfig.FAMILIAR_REPORT_SURROUNDINGS_TIME, false);
                            PlayerManaManager.updateClientMahou((ServerPlayer)this.getOwner(), mahou);
                        }
                        toSend = this.reportBlock(this.level().getBlockState(this.lastInteresting).getBlock(), owner);
                    }
                }
            }
            if (toSend != null && !toSend.getString().equals("")) {
                owner.displayClientMessage((Component)Component.literal((String)(this.getMyName() + ": " + toSend.getString())).withStyle(ChatFormatting.AQUA), MTConfig.FAMILIAR_ACTION_BAR_MESSAGES);
            }
        }
    }

    public String getMyName() {
        if (this.hasCustomName()) {
            return this.getCustomName().getString();
        }
        return "Familiar";
    }

    public boolean isInterestingBlock(Block b) {
        return b == Blocks.DIAMOND_ORE || b == Blocks.EMERALD_ORE || b == Blocks.LAPIS_ORE || b == Blocks.BOOKSHELF || b == Blocks.OBSIDIAN || b == Blocks.PRISMARINE || b == Blocks.GOLD_ORE || b == Blocks.END_PORTAL_FRAME;
    }

    public MutableComponent ouch(Player owner) {
        RandomSource rand = owner.getRandom();
        int textNum = 1 + rand.nextInt(7);
        MutableComponent tct = Component.translatable((String)("mahoutsukai.hurt" + textNum));
        return tct;
    }

    public MutableComponent getGreeting(Player owner) {
        MutableComponent tct = Component.translatable((String)"");
        RandomSource rand = owner.getRandom();
        int textNum = rand.nextInt(7);
        if (textNum > 0) {
            if (this.getHoliday() && this.whichHoliday() != 0) {
                tct.append((Component)Component.translatable((String)("mahoutsukai.holiday" + this.whichHoliday() + "greeting" + textNum)));
            } else {
                tct.append((Component)Component.translatable((String)("mahoutsukai.greeting" + textNum)));
            }
            tct.append((Component)Component.literal((String)" "));
        }
        tct.append((Component)Component.translatable((String)"mahoutsukai.masta"));
        tct.append((Component)Component.literal((String)", "));
        return tct;
    }

    public MutableComponent reportBlock(Block thing, Player owner) {
        MutableComponent tct = null;
        RandomSource rand = owner.getRandom();
        if (thing != null) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.append((Component)Component.translatable((String)("mahoutsukai.found" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.translatable((String)thing.getDescriptionId())).getString();
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.translatable((String)("mahoutsukai.foundF" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            textNum = 1 + rand.nextInt(4);
            tct.append((Component)Component.translatable((String)("mahoutsukai.followup" + textNum)));
        }
        return tct;
    }

    public MutableComponent reportEntity(LivingEntity thing, Player owner) {
        MutableComponent tct = null;
        RandomSource rand = owner.getRandom();
        if (thing != null && !(thing instanceof Player) && thing != this) {
            tct = this.getGreeting(owner);
            int textNum = 1 + rand.nextInt(3);
            tct.append((Component)Component.translatable((String)("mahoutsukai.entityFound" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.translatable((String)thing.getName().getString()));
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.translatable((String)("mahoutsukai.entityFoundF" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            textNum = 1 + rand.nextInt(7);
            tct.append((Component)Component.translatable((String)("mahoutsukai.entityFoundFollowUp" + textNum)));
        }
        return tct;
    }

    public MutableComponent reportPlayer(Player player, Player owner) {
        MutableComponent tct = null;
        RandomSource rand = owner.getRandom();
        if (player != null && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getOwnerUUID(), (Entity)player)) {
            tct = this.getGreeting(owner);
            BlockPos position = player.blockPosition();
            int textNum = 1 + rand.nextInt(3);
            tct.append((Component)Component.translatable((String)("mahoutsukai.playerFound" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.translatable((String)player.getName().getString()));
            tct.append((Component)Component.translatable((String)("mahoutsukai.playerFoundF" + textNum)));
            tct.append((Component)Component.literal((String)" "));
            tct.append((Component)Component.literal((String)("[" + position.getX() + "," + position.getY() + "," + position.getZ() + "]. ")));
            textNum = 1 + rand.nextInt(7);
            tct.append((Component)Component.translatable((String)("mahoutsukai.entityFoundFollowUp" + textNum)));
        }
        return tct;
    }

    public void loadChunks() {
        if (this.ticket == null && !this.level().isClientSide && this.getOwner() != null && MTConfig.FAMILIAR_CHUNKLOADS) {
            this.ticket = TicketType.create((String)(String.valueOf(this.getOwner().getName()) + "familiar"), Comparator.comparingLong(ChunkPos::toLong));
        } else if (this.ticket != null && !this.level().isClientSide && this.getOwner() != null && MTConfig.FAMILIAR_CHUNKLOADS) {
            ChunkPos pos = new ChunkPos(this.blockPosition());
            ((ServerLevel)this.level()).getChunkSource().addRegionTicket(this.ticket, pos, 1, (Object)pos);
        }
    }

    public ChunkPos add(int x, int z, ChunkPos pos) {
        return new ChunkPos(pos.x + x, pos.z + z);
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.ticket != null) {
            ((ServerLevel)this.level()).getChunkSource().removeRegionTicket(this.ticket, new ChunkPos(this.blockPosition()), 1, (Object)new ChunkPos(this.blockPosition()));
            this.ticket = null;
        }
        super.remove(reason);
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround() ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, motion.y * 0.6, motion.z);
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean groundIn, BlockState state, BlockPos pos) {
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    public boolean doHurtTarget(Entity entityIn) {
        return entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), 3.0f);
    }

    public boolean isPushable() {
        return true;
    }

    protected void doPush(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.doPush(entityIn);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.getOwner() != null && !this.level().isClientSide && this.getRandom().nextDouble() > MTConfig.FAMILIAR_OUCH_CHANCE && this.getOwner() instanceof Player) {
            ((Player)this.getOwner()).displayClientMessage((Component)Component.literal((String)(this.getMyName() + ": " + this.ouch((Player)this.getOwner()).withStyle(ChatFormatting.AQUA).getString())), true);
        }
        return super.hurt(source, amount);
    }

    public UUID getFamiliarId() {
        return this.familiarId;
    }

    public void setFamiliarId(UUID f) {
        this.familiarId = f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(GARDEN_TICKS, (Object)0);
        builder.define(HOLIDAY, (Object)true);
        super.defineSynchedData(builder);
    }

    public void setColor(float r, float g, float b) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue()};
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.familiarId != null) {
            compound.putUUID("mahoutsukai_familiar_id", this.familiarId);
        }
        if (this.getOwnerUUID() != null) {
            compound.putUUID("mahoutsukai_familiar_owner_id", this.getOwnerUUID());
        }
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putInt(TAG_GARDEN_TICKS, this.getGardenTicks());
        compound.putBoolean(TAG_HOLIDAY, this.getHoliday());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("mahoutsukai_familiar_id")) {
            this.familiarId = compound.getUUID("mahoutsukai_familiar_id");
        }
        if (compound.hasUUID("mahoutsukai_familiar_owner_id")) {
            this.setOwnerUUID(compound.getUUID("mahoutsukai_familiar_owner_id"));
        }
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B));
        this.setGardenTicks(compound.getInt(TAG_GARDEN_TICKS));
        this.setHoliday(compound.getBoolean(TAG_HOLIDAY));
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob ageableEntity) {
        return null;
    }
}

