/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.settingsmahou;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import stepsword.mahoutsukai.dataattachments.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SettingsMahouPacket;
import stepsword.mahoutsukai.util.Utils;

public class MahouSettings {
    public static ConcurrentHashMap<Integer, List<Integer>> intsettings;
    public static HashSet<Spell> primaryColor;
    public static HashSet<Spell> secondaryColor;

    public static ConcurrentHashMap<Integer, List<Integer>> getIntDefaults() {
        intsettings = new ConcurrentHashMap();
        intsettings.put(Spell.RHO_AIAS.ordinal(), Arrays.asList(255, 94, 204, 255, 94, 204));
        intsettings.put(Spell.GANDR.ordinal(), Arrays.asList(216, 0, 0, 0, 0, 0));
        intsettings.put(Spell.TREASURY_WEAPONS.ordinal(), Arrays.asList(255, 255, 150, 0, 0, 0));
        intsettings.put(Spell.TREASURY_CHAINS.ordinal(), Arrays.asList(244, 237, 64, 0, 0, 0));
        intsettings.put(Spell.MORGAN.ordinal(), Arrays.asList(255, 50, 50, 0, 0, 0));
        intsettings.put(Spell.MORGAN_BALL.ordinal(), Arrays.asList(150, 0, 0, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_BIG.ordinal(), Arrays.asList(224, 64, 0, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_AOE.ordinal(), Arrays.asList(166, 125, 224, 0, 0, 0));
        intsettings.put(Spell.MYSTIC_STAFF_BEAM.ordinal(), Arrays.asList(140, 82, 191, 0, 0, 0));
        intsettings.put(Spell.WEAPON_PROJECTILE.ordinal(), Arrays.asList(179, 255, 255, 179, 255, 255));
        intsettings.put(Spell.NOBU.ordinal(), Arrays.asList(255, 255, 179, 255, 255, 255));
        intsettings.put(Spell.WILLIAM_BOOK.ordinal(), Arrays.asList(69, 5, 171, 196, 170, 149));
        intsettings.put(Spell.WILLIAM_MAGIC.ordinal(), Arrays.asList(100, 49, 181, 173, 122, 255));
        intsettings.put(Spell.RLYEH_BOOK.ordinal(), Arrays.asList(0, 51, 64, 90, 90, 90));
        intsettings.put(Spell.RLYEH_MAGIC.ordinal(), Arrays.asList(100, 255, 255, 100, 255, 255));
        return intsettings;
    }

    public static boolean hasPrimary(Spell spell) {
        return primaryColor.contains((Object)spell);
    }

    public static boolean hasSecondary(Spell spell) {
        return secondaryColor.contains((Object)spell);
    }

    public static List<Integer> getIntSettings(Player player, Spell spell) {
        ISettingsMahou settings = Utils.getSettingsMahou((LivingEntity)player);
        if (settings != null) {
            try {
                List<Integer> ret = settings.getIntSettings(spell.ordinal());
                List<Integer> defaults = MahouSettings.getIntDefaults().get(spell.ordinal());
                if (ret.size() < defaults.size()) {
                    for (int i = ret.size(); i < defaults.size(); ++i) {
                        ret.add(defaults.get(i));
                    }
                }
                return ret;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return MahouSettings.getIntDefaults().get(spell.ordinal());
    }

    public static void updateClientMahou(ServerPlayer player) {
        ISettingsMahou mahou;
        if (player != null && (mahou = Utils.getSettingsMahou((LivingEntity)player)) != null) {
            PacketHandler.sendTo(player, new SettingsMahouPacket(mahou));
        }
    }

    static {
        primaryColor = new HashSet<Spell>(Arrays.asList(Spell.RHO_AIAS, Spell.GANDR, Spell.TREASURY_WEAPONS, Spell.TREASURY_CHAINS, Spell.MORGAN, Spell.MORGAN_BALL, Spell.MYSTIC_STAFF_BIG, Spell.MYSTIC_STAFF_BEAM, Spell.MYSTIC_STAFF_AOE, Spell.WEAPON_PROJECTILE, Spell.NOBU, Spell.WILLIAM_BOOK, Spell.WILLIAM_MAGIC, Spell.RLYEH_BOOK, Spell.RLYEH_MAGIC));
        secondaryColor = new HashSet<Spell>(Arrays.asList(Spell.RHO_AIAS, Spell.GANDR, Spell.MORGAN_BALL, Spell.WEAPON_PROJECTILE, Spell.NOBU, Spell.WILLIAM_BOOK, Spell.WILLIAM_MAGIC, Spell.RLYEH_BOOK, Spell.RLYEH_MAGIC));
    }

    public static enum Spell {
        RHO_AIAS,
        GANDR,
        TREASURY_WEAPONS,
        TREASURY_CHAINS,
        MORGAN,
        MORGAN_BALL,
        MYSTIC_STAFF_BIG,
        MYSTIC_STAFF_BEAM,
        MYSTIC_STAFF_AOE,
        WEAPON_PROJECTILE,
        NOBU,
        WILLIAM_BOOK,
        WILLIAM_MAGIC,
        RLYEH_BOOK,
        RLYEH_MAGIC;

    }
}

