/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.networking.DoneMentalPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class MentalDisplacementClientEffect {
    public static Entity mentalPlaceholder = null;

    public static void mentalDisplacementInputUpdate(Input mi, Player player) {
        if (player != null && Minecraft.getInstance().getCameraEntity() instanceof MentalDisplacementEntity) {
            MentalDisplacementEntity entity = (MentalDisplacementEntity)Minecraft.getInstance().getCameraEntity();
            entity.updateInputs(mi.down, mi.up, mi.left, mi.right, mi.jumping, mi.shiftKeyDown);
            entity.lerpTo(entity.getX(), entity.getY(), entity.getZ(), player.yRot, player.xRot, 3);
            if (MentalDisplacementSpellEffect.checkDistance(entity.origPos, Utils.toBlockPos(new Vec3(entity.getX(), entity.getY(), entity.getZ()))) < MTConfig.MENTAL_DISPLACEMENT_RANGE) {
                mi.down = false;
                mi.up = false;
                mi.jumping = false;
                mi.shiftKeyDown = false;
                mi.left = false;
                mi.right = false;
            } else {
                Minecraft.getInstance().setCameraEntity((Entity)player);
                PacketHandler.sendToServer(new DoneMentalPacket());
            }
        }
    }

    public static void mentalDisplacementMouseInput() {
        KeyMapping k;
        if (Minecraft.getInstance().getCameraEntity() instanceof MentalDisplacementEntity && (k = Minecraft.getInstance().options.keyAttack).consumeClick()) {
            k.release();
            MentalDisplacementClientEffect.mentalDisplacementDisallowedAction((Player)Minecraft.getInstance().player);
        }
    }

    public static boolean mentalDisplacementRenderHand() {
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.getInstance().player);
        return mahou != null && Minecraft.getInstance().getCameraEntity() instanceof MentalDisplacementEntity;
    }

    public static void mentalDisplacementRenderWorldLast(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        Vec3 Vec32 = renderInfo.getPosition();
        double xx = Vec32.x();
        double yy = Vec32.y();
        double zz = Vec32.z();
        double d0 = Mth.lerp((double)partialTicks, (double)player.xOld, (double)player.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)player.yOld, (double)player.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)player.zOld, (double)player.getZ());
        float f = Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.yRot);
        Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)player, d0 - xx, d1 - yy, d2 - zz, f, partialTicks, event.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 240);
    }

    public static boolean mentalDisplacementDisallowedAction(Player player) {
        boolean ret = false;
        if (player != null && Minecraft.getInstance().getCameraEntity() instanceof MentalDisplacementEntity) {
            Minecraft.getInstance().setCameraEntity((Entity)player);
            PacketHandler.sendToServer(new DoneMentalPacket());
            ret = true;
        }
        return ret;
    }

    public static void mentalDisplacementEntityJoin(final Entity entity) {
        if (entity instanceof MentalDisplacementEntity) {
            Minecraft.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    LocalPlayer player;
                    if (entity.level().isClientSide && entity instanceof MentalDisplacementEntity && entity.isAlive() && (player = Minecraft.getInstance().player).getUUID().equals(((MentalDisplacementEntity)entity).getOwnerId())) {
                        Minecraft.getInstance().setCameraEntity(entity);
                        ((MentalDisplacementEntity)entity).origPos = Utils.toBlockPos(new Vec3(entity.getX(), entity.getY(), entity.getZ()));
                    }
                }
            });
        }
    }
}

