/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.food;

import com.mamailes.merrymaking.util.DinnerShapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EdiblePieBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)8);

    public EdiblePieBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int bites = (Integer)state.getValue((Property)BITES);
        return switch (bites) {
            case 1 -> DinnerShapes.BITE_1;
            case 2 -> DinnerShapes.BITE_2;
            case 3 -> DinnerShapes.BITE_3;
            case 4 -> DinnerShapes.BITE_4;
            case 5 -> DinnerShapes.BITE_5;
            case 6 -> DinnerShapes.BITE_6;
            case 7 -> DinnerShapes.BITE_7;
            case 8 -> DinnerShapes.BITE_ALL;
            default -> DinnerShapes.BITE_0;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (EdiblePieBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return EdiblePieBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(8, 0.8f);
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }
}

