/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import net.minecraft.network.chat.Component;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integratedtunnels.core.TunnelHelpers;

public class TunnelEnergyHelpers {
    public static long moveEnergy(INetwork network, IPositionedAddonsNetworkIngredients<Long, Boolean> ingredientsNetwork, int channel, IIngredientComponentStorage<Long, Boolean> source, IIngredientComponentStorage<Long, Boolean> target, long amount, boolean exact, boolean craftIfFailed) throws EvaluationException {
        long moved;
        try {
            moved = (Long)IngredientStorageHelpers.moveIngredients(source, target, (Object)amount, (Object)exact, (boolean)false);
        }
        catch (InconsistentIngredientInsertionException e) {
            throw new EvaluationException(Component.literal((String)"Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Lost ").append((Component)e.getIngredientComponent().getMatcher().getDisplayName(e.getRemainder())));
        }
        ingredientsNetwork.scheduleObservation();
        if (craftIfFailed && moved == 0L && (Long)target.insert((Object)amount, true) == amount) {
            TunnelHelpers.requestCrafting(network, ingredientsNetwork, channel, amount, exact);
        }
        return moved;
    }
}

