/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public class RenderPlayer
extends Zombie {
    static final EntityDataAccessor<String> DATA_UUID = SynchedEntityData.defineId(RenderPlayer.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public RenderPlayer(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_UUID, (Object)"");
    }

    public void setUUIDData(String uuid) {
        this.getEntityData().set(DATA_UUID, (Object)uuid);
    }

    public String getUUIDData() {
        return (String)this.getEntityData().get(DATA_UUID);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("uuid")) {
            this.setUUIDData(tag.getString("uuid"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.getUUIDData().isEmpty()) {
            tag.putString("uuid", this.getUUIDData());
        }
    }
}

