/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.layers.JellyfishLayer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class AquaFishRenderer
extends MobRenderer<AquaFishEntity, EntityModel<AquaFishEntity>> {
    private static final ResourceLocation DEFAULT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/entity/fish/atlantic_cod.png");
    private final TropicalFishModelB<AquaFishEntity> tropicalFishBModel;
    private final FishSmallModel<AquaFishEntity> smallModel;
    private final FishMediumModel<AquaFishEntity> mediumModel;
    private final FishLargeModel<AquaFishEntity> largeModel;
    private final FishLongnoseModel<AquaFishEntity> longnoseModel;
    private final FishCathfishModel<AquaFishEntity> catfishModel;
    private final JellyfishModel<AquaFishEntity> jellyfishModel;

    public AquaFishRenderer(EntityRendererProvider.Context context, boolean isJellyfish) {
        super(context, new FishMediumModel(context.bakeLayer(ClientHandler.MEDIUM_MODEL)), 0.35f);
        this.tropicalFishBModel = new TropicalFishModelB(context.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE));
        this.smallModel = new FishSmallModel(context.bakeLayer(ClientHandler.SMALL_MODEL));
        this.mediumModel = new FishMediumModel(context.bakeLayer(ClientHandler.MEDIUM_MODEL));
        this.largeModel = new FishLargeModel(context.bakeLayer(ClientHandler.LARGE_MODEL));
        this.longnoseModel = new FishLongnoseModel(context.bakeLayer(ClientHandler.LONGNOSE_MODEL));
        this.catfishModel = new FishCathfishModel(context.bakeLayer(ClientHandler.CATFISH_MODEL));
        this.jellyfishModel = new JellyfishModel(context.bakeLayer(ClientHandler.JELLYFISH_MODEL));
        if (isJellyfish) {
            this.addLayer(new JellyfishLayer(this, context.getModelSet()));
        }
    }

    public void render(@Nonnull AquaFishEntity fishEntity, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        if (fishEntity != null) {
            switch (fishEntity.getFishType()) {
                case SMALL: {
                    this.model = this.smallModel;
                    break;
                }
                case LARGE: {
                    this.model = this.largeModel;
                    break;
                }
                case LONGNOSE: {
                    this.model = this.longnoseModel;
                    break;
                }
                case CATFISH: {
                    this.model = this.catfishModel;
                    break;
                }
                case JELLYFISH: {
                    this.model = this.jellyfishModel;
                    break;
                }
                case HALIBUT: {
                    this.model = this.tropicalFishBModel;
                    break;
                }
                default: {
                    this.model = this.mediumModel;
                }
            }
            super.render((LivingEntity)fishEntity, entityYaw, partialTicks, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquaFishEntity fishEntity) {
        ResourceLocation location = BuiltInRegistries.ENTITY_TYPE.getKey((Object)fishEntity.getType());
        if (location != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)("textures/entity/fish/" + location.getPath() + ".png"));
        }
        return DEFAULT_LOCATION;
    }

    protected void setupRotations(@Nonnull AquaFishEntity fishEntity, @Nonnull PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float f) {
        super.setupRotations((LivingEntity)fishEntity, matrixStack, ageInTicks, rotationYaw, partialTicks, f);
        FishType fishType = fishEntity.getFishType();
        if (fishType != FishType.JELLYFISH) {
            float salmonRotation = 1.0f;
            float salmonMultiplier = 1.0f;
            if (fishType == FishType.LONGNOSE && !fishEntity.isInWater()) {
                salmonRotation = 1.3f;
                salmonMultiplier = 1.7f;
            }
            float fishRotation = fishType == FishType.LONGNOSE ? salmonRotation * 4.3f * Mth.sin((float)(salmonMultiplier * 0.6f * ageInTicks)) : 4.3f * Mth.sin((float)(0.6f * ageInTicks));
            matrixStack.mulPose(Axis.YP.rotationDegrees(fishRotation));
            if (fishType == FishType.LONGNOSE) {
                matrixStack.translate(0.0f, 0.0f, -0.4f);
            }
            if (!fishEntity.isInWater() && fishType != FishType.HALIBUT) {
                if (fishType == FishType.MEDIUM || fishType == FishType.LARGE || fishType == FishType.CATFISH) {
                    matrixStack.translate(0.1f, 0.1f, -0.1f);
                } else {
                    matrixStack.translate(0.2f, 0.1f, 0.0f);
                }
                matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            if (fishType == FishType.HALIBUT) {
                matrixStack.translate(-0.4f, 0.1f, 0.0f);
                matrixStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
        }
    }

    protected void scale(AquaFishEntity fishEntity, @Nonnull PoseStack matrixStack, float partialTickTime) {
        ResourceLocation location = BuiltInRegistries.ENTITY_TYPE.getKey((Object)fishEntity.getType());
        float scale = 0.0f;
        if (location != null) {
            switch (location.getPath()) {
                case "minnow": {
                    scale = 0.5f;
                    break;
                }
                case "synodontis": {
                    scale = 0.8f;
                    break;
                }
                case "brown_trout": 
                case "piranha": {
                    scale = 0.9f;
                    break;
                }
                case "pollock": {
                    scale = 1.1f;
                    break;
                }
                case "atlantic_cod": 
                case "blackfish": 
                case "catfish": 
                case "tambaqui": {
                    scale = 1.2f;
                    break;
                }
                case "pacific_halibut": 
                case "atlantic_halibut": 
                case "capitaine": 
                case "largemouth_bass": 
                case "gar": 
                case "arapaima": 
                case "tuna": {
                    scale = 1.4f;
                }
            }
        }
        if (scale > 0.0f) {
            matrixStack.pushPose();
            matrixStack.scale(scale, scale, scale);
            matrixStack.popPose();
        }
    }
}

