/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PointsPlateWidget
extends AbstractPlateWidget {
    public PointsPlateWidget(int x, int y, IRelicScreenProvider provider) {
        super(x, y, provider, "leveling_point");
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.getProvider().getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.general.leveling_point.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + relic.getRelicLevelingPoints(stack)), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"tooltip.relics.researching.general.leveling_point.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void onTick() {
    }

    @Override
    public String getValue(ItemStack stack) {
        String string;
        Item item = stack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            string = String.valueOf(relic.getRelicLevelingPoints(stack));
        } else {
            string = "";
        }
        return string;
    }
}

