/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.general.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.badges.base.AbilityBadge;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AbilityBadgeWidget
extends AbstractBadgeWidget {
    private final AbilityBadge badge;
    private final String ability;

    public AbilityBadgeWidget(int x, int y, IRelicScreenProvider provider, AbilityBadge badge, String ability) {
        super(x, y, provider, badge);
        this.badge = badge;
        this.ability = ability;
    }

    @Override
    public AbilityBadge getBadge() {
        return this.badge;
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = this.getProvider().getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{this.getBadge().getTitle(stack, this.ability).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE), Component.literal((String)" ")});
        entries.addAll(this.getBadge().getDescription(stack, this.ability));
        List<MutableComponent> hint = this.getBadge().getHint(stack, this.ability);
        if (!hint.isEmpty()) {
            entries.add(Component.literal((String)" "));
            if (Screen.hasShiftDown()) {
                entries.addAll(hint.stream().map(entry -> entry.withStyle(ChatFormatting.ITALIC)).toList());
            } else {
                entries.add(Component.translatable((String)"tooltip.relics.researching.general.extra_info"));
            }
        }
        for (MutableComponent entry2 : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry2) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry2, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry3 : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry3, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }
}

