/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.entities.SporeModel;
import it.hurts.sskirillss.relics.entities.SporeEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SporeRenderer
extends EntityRenderer<SporeEntity> {
    public SporeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(SporeEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.tickCount < 5) {
            return;
        }
        float time = (float)entityIn.tickCount + (Minecraft.getInstance().isPaused() ? 0.0f : partialTicks);
        poseStack.pushPose();
        float scale = (float)((double)Math.clamp((float)entityIn.tickCount * 0.0175f, 0.0f, 0.5f) + Math.sin(time * 0.1f) * (double)0.05f);
        poseStack.translate(0.0f, 0.05f, 0.0f);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotation(time * 0.25f));
        poseStack.mulPose(Axis.ZN.rotation(time * 0.25f));
        new SporeModel().renderToBuffer(poseStack, bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn))), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(SporeEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/entities/spore.png");
    }
}

