/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.miner;

import alexthw.starbunclemania.starbuncle.miner.StarbyMinerBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MineBlockGoal<T extends StarbyMinerBehavior>
extends GoToPosGoal<T> {
    BlockPos miningPos;
    int destroyTimer;

    public MineBlockGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> !behavior.isBedPowered() && starbuncle.getHeldStack().isEmpty());
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    public BlockPos getDestination() {
        return ((StarbyMinerBehavior)this.behavior).getValidMinePos();
    }

    public boolean canUse() {
        return super.canUse() && this.starbuncle.getHeldStack().isEmpty();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.starbuncle.level().getBlockState(this.targetPos).isAir();
    }

    public void tick() {
        super.tick();
        if (this.miningPos != null && this.destroyTimer != -1) {
            BlockState blockState = this.starbuncle.level().getBlockState(this.miningPos);
            if (blockState.isAir()) {
                this.destroyTimer = -1;
                this.miningPos = null;
                return;
            }
            ++this.destroyTimer;
            float percentage = (float)this.destroyTimer / ((StarbyMinerBehavior)this.behavior).getToolToUse().getDestroySpeed(blockState);
            if (percentage > 1.0f) {
                this.destroyTimer = -1;
                if (this.starbuncle.level().destroyBlock(this.miningPos, false, (Entity)this.starbuncle)) {
                    Block.dropResources((BlockState)blockState, (Level)this.starbuncle.level(), (BlockPos)this.miningPos, (BlockEntity)(blockState.hasBlockEntity() ? this.starbuncle.level().getBlockEntity(this.miningPos) : null), (Entity)this.starbuncle, (ItemStack)((StarbyMinerBehavior)this.behavior).getToolToUse());
                }
                this.miningPos = null;
                return;
            }
            this.starbuncle.level().destroyBlockProgress(this.starbuncle.getId(), this.miningPos, (int)(percentage * 10.0f));
        }
    }

    public boolean onDestinationReached() {
        if (this.destroyTimer > 0) {
            return true;
        }
        BlockState blockState = this.starbuncle.level().getBlockState(this.targetPos);
        if (blockState.isAir()) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(10));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("no_block", "No block at " + this.targetPos.toString()));
            return true;
        }
        if (!((StarbyMinerBehavior)this.behavior).canMineBlock(this.targetPos)) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("permission_denied", "Can't mine " + String.valueOf(blockState.getBlock()) + " at " + this.targetPos.toString()));
            return true;
        }
        this.miningPos = this.targetPos;
        if (this.destroyTimer == -1) {
            this.destroyTimer = 0;
        }
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("start_mine", "Started mining " + String.valueOf(blockState.getBlock()) + " at " + this.targetPos.toString()));
        return false;
    }
}

