/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.gas;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.item.cosmetic.StarBalloon;
import alexthw.starbunclemania.starbuncle.StarHelper;
import alexthw.starbunclemania.starbuncle.gas.GasExtractGoal;
import alexthw.starbunclemania.starbuncle.gas.GasStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyGasBehavior
extends StarbyListBehavior {
    private ChemicalStack gasStack = ChemicalStack.EMPTY;
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_gas_transport");

    public StarbyGasBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("gas")) {
            this.gasStack = ChemicalStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("gas"));
        }
        this.goals.add(new WrappedGoal(3, (Goal)new GasStoreGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new GasExtractGoal(entity, this)));
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getTankToExtract() == null && (this.getGasStack().isEmpty() || this.getTankForStorage() == null);
    }

    @NotNull
    public ChemicalStack getGasStack() {
        return this.gasStack;
    }

    public void setGasStack(ChemicalStack gas) {
        this.gasStack = gas;
        this.syncTag();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.starbuncle.level().getCapability(Capabilities.CHEMICAL.block(), storedPos, (Object)face) != null) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.gas_to"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.starbuncle.level().getCapability(Capabilities.CHEMICAL.block(), storedPos, (Object)face) != null) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.gas_from"));
        }
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing_gas", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking_gas", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.gasStack.isEmpty()) {
            tooltip.accept((Component)Component.literal((String)(this.getGasStack().getAmount() + " ")).append((Component)Component.translatable((String)this.getGasStack().getTranslationKey())));
        }
    }

    public int getRatio() {
        return (Integer)Configs.STARBALLOON_RATIO.get();
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public BlockPos getTankForStorage(ChemicalStack gasInTank) {
        if (!gasInTank.isEmpty()) {
            for (BlockPos pos : this.TO_LIST) {
                if (!this.level.isLoaded(pos) || !this.canStore(pos, gasInTank)) continue;
                return pos;
            }
        }
        return null;
    }

    public BlockPos getTankForStorage() {
        return this.getTankForStorage(this.getGasStack());
    }

    public BlockPos getTankToExtract() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.level.isLoaded(pos) || !this.canExtract(pos)) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static IChemicalHandler getHandlerFromCap(BlockPos pos, Level level, Direction side) {
        if (side == null) {
            side = Direction.NORTH;
        }
        side = StarHelper.checkItemFramesForSide(pos, level, side);
        return (IChemicalHandler)level.getCapability(Capabilities.CHEMICAL.block(), pos, (Object)side);
    }

    public IChemicalHandler getHandlerFromCap(BlockPos pos, Direction side) {
        return StarbyGasBehavior.getHandlerFromCap(pos, this.level, side);
    }

    public boolean canStore(BlockPos pos, @NotNull ChemicalStack gasStack) {
        IChemicalHandler gas = this.getHandlerFromCap(pos, (Direction)this.TO_DIRECTION_MAP.get(pos.hashCode()));
        if (gas != null) {
            for (int i = 0; i < gas.getChemicalTanks(); ++i) {
                if (!gas.isValid(i, gasStack) || gas.insertChemical(gasStack, Action.SIMULATE).getAmount() > (long)((Integer)Configs.STARBALLOON_THRESHOLD.get()).intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canExtract(BlockPos pos) {
        IChemicalHandler gas = this.getHandlerFromCap(pos, (Direction)this.FROM_DIRECTION_MAP.get(pos.hashCode()));
        if (gas != null) {
            for (int i = 0; i < gas.getChemicalTanks(); ++i) {
                if (gas.getChemicalInTank(i).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.getGasStack().isEmpty()) {
            tag.put("gas", this.getGasStack().save((HolderLookup.Provider)this.level.registryAccess()));
        }
        return super.toTag(tag);
    }

    public ItemStack getStackForRender() {
        if (this.starbuncle.getCosmeticItem().getItem() instanceof StarBalloon) {
            this.starbuncle.getCosmeticItem().set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(this.gasStack.getChemicalColorRepresentation(), false));
        }
        return ItemStack.EMPTY;
    }
}

