/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.fluid;

import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidStoreGoal
extends GoToPosGoal<StarbyFluidBehavior> {
    public FluidStoreGoal(Starbuncle starbuncle, StarbyFluidBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> !behavior.getFluidStack().isEmpty());
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Nullable
    public BlockPos getDestination() {
        return ((StarbyFluidBehavior)this.behavior).getTankForStorage();
    }

    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyFluidBehavior)this.behavior).canStore(pos, ((StarbyFluidBehavior)this.behavior).getFluidStack());
    }

    public boolean onDestinationReached() {
        this.starbuncle.getNavigation().stop();
        IFluidHandler fluidHandler = ((StarbyFluidBehavior)this.behavior).getHandlerFromCap(this.targetPos, (Direction)((StarbyFluidBehavior)this.behavior).TO_DIRECTION_MAP.get(this.targetPos.hashCode()));
        if (fluidHandler == null) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoFluidHandler", "No fluid handler at " + this.targetPos.toString()));
            return true;
        }
        int room = fluidHandler.fill(((StarbyFluidBehavior)this.behavior).getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
        if (room <= 0) {
            this.starbuncle.setBackOff(5 + this.starbuncle.level().random.nextInt(20));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("no_room", this.targetPos.toString()));
            return true;
        }
        FluidStack fill = new FluidStack(((StarbyFluidBehavior)this.behavior).getFluidStack().getFluid(), room);
        int diff = fluidHandler.fill(fill, IFluidHandler.FluidAction.EXECUTE);
        ((StarbyFluidBehavior)this.behavior).getFluidStack().shrink(diff);
        ((StarbyFluidBehavior)this.behavior).syncTag();
        if (diff > 0) {
            this.starbuncle.level().playSound(null, this.targetPos, SoundEvents.BUCKET_EMPTY, SoundSource.NEUTRAL, 0.2f, 1.3f);
        }
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("stored_fluid", "successful at " + this.targetPos.toString() + ". Trasferred MBs : " + diff));
        return true;
    }
}

