/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.item.cosmetic;

import alexthw.starbunclemania.common.item.cosmetic.PlayerCurioCosmetic;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarStarbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChefHat
extends PlayerCurioCosmetic
implements ICosmeticItem {
    static final Vec3 wixieTransl = new Vec3(0.0, 0.68, 0.15);
    static final Vec3 starbScale = new Vec3(0.9, 0.8, 0.9);
    static final Vec3 starbTransl = new Vec3(0.0, 0.3, 0.02);

    public ChefHat(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (interactionTarget instanceof IDecoratable) {
            IDecoratable deco = (IDecoratable)interactionTarget;
            if (this.canWear(interactionTarget)) {
                deco.setCosmeticItem(stack.split(1));
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public Vec3 getTranslations(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarWixie.class}, (Object)livingEntity, n)) {
            case 0 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity;
                yield wixieTransl;
            }
            default -> starbTransl;
        };
    }

    public Vec3 getScaling(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarWixie.class}, (Object)livingEntity, n)) {
            case 0 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity;
                yield defaultScaling;
            }
            default -> starbScale;
        };
    }

    public boolean canWear(LivingEntity entity) {
        return entity instanceof FamiliarWixie || entity instanceof FamiliarStarbuncle || entity instanceof Starbuncle;
    }

    public String getBone(LivingEntity entity) {
        return entity instanceof FamiliarWixie ? "hat" : "head";
    }
}

