/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.to_client.OpenChest;
import edivad.dimstorage.tools.InventoryUtils;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class DimChestStorage
extends AbstractDimStorage
implements Container {
    private ItemStack[] items;
    private int open;

    public DimChestStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(HolderLookup.Provider registries, CompoundTag tag) {
        this.empty();
        InventoryUtils.readItemStacksFromTag(registries, this.items, tag.getList("items", 10));
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundTag saveToTag(HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        compound.put("items", (Tag)InventoryUtils.writeItemStacksToTag(registries, this.items));
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getItem(int slot) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItemNoUpdate(int index) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.removeStackFromSlot(this, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int slot, ItemStack stack) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items[slot] = stack;
            this.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                ++this.open;
                if (this.open >= 1) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new OpenChest(this.freq, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                --this.open;
                if (this.open <= 0) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new OpenChest(this.freq, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int getContainerSize() {
        return 54;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItem(int slot, int size) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.decrStackSize(this, slot, size);
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.setDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items = new ItemStack[this.getContainerSize()];
            Arrays.fill(this.items, ItemStack.EMPTY);
        }
    }

    public void setClientOpen(int i) {
        if (!this.manager.isServer()) {
            this.open = i;
        }
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void clearContent() {
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }
}

