/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.menu;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.items.components.DimStorageComponents;
import edivad.dimstorage.items.components.FrequencyTabletComponent;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.menu.DimStorageMenu;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimChestStorage;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DimTabletMenu
extends DimStorageMenu {
    private final DimChestStorage chestInv;

    public DimTabletMenu(int windowId, Inventory inventory, Level level) {
        super((MenuType)Registration.DIMTABLET_MENU.get(), windowId);
        ItemStack item = inventory.player.getItemInHand(InteractionHand.MAIN_HAND);
        Frequency frequency = ((FrequencyTabletComponent)item.get(DimStorageComponents.FREQUENCY_TABLET)).frequency();
        this.chestInv = (DimChestStorage)DimStorageManager.instance(level).getStorage((HolderLookup.Provider)level.registryAccess(), frequency, "item");
        this.chestInv.openInventory();
        this.addOwnSlots();
        this.addInventorySlots((Container)inventory);
    }

    private void addOwnSlots() {
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)this.chestInv, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.chestInv.closeInventory();
    }
}

