/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.element.button;

import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.network.to_server.UpdateDimChest;
import edivad.dimstorage.network.to_server.UpdateDimTank;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class LockButton
extends AbstractButton {
    private final BlockEntityFrequencyOwner owner;

    public LockButton(int width, int height, BlockEntityFrequencyOwner owner) {
        super(width, height, 64, 20, LockButton.getText(owner.locked));
        this.owner = owner;
    }

    private static Component getText(boolean isLock) {
        return Component.translatable((String)(isLock ? "gui.dimstorage.yes" : "gui.dimstorage.no"));
    }

    public void onPress() {
        this.owner.swapLocked();
        BlockEntityFrequencyOwner blockEntityFrequencyOwner = this.owner;
        if (blockEntityFrequencyOwner instanceof BlockEntityDimChest) {
            BlockEntityDimChest chest = (BlockEntityDimChest)blockEntityFrequencyOwner;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateDimChest(chest), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            blockEntityFrequencyOwner = this.owner;
            if (blockEntityFrequencyOwner instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)blockEntityFrequencyOwner;
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateDimTank(tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

