/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.menu;

import earth.terrarium.tempad.common.block.MetronomeItemHandler;
import earth.terrarium.tempad.common.menu.MetronomeMenuData;
import earth.terrarium.tempad.common.registries.ModMenus;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\f\u0010\u000fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u0003H\u0002J$\u0010 \u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u0003H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Learth/terrarium/tempad/common/menu/MetronomeMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "inv", "Lnet/minecraft/world/entity/player/Inventory;", "items", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "energy", "Lnet/minecraft/world/inventory/ContainerData;", "data", "Learth/terrarium/tempad/common/menu/MetronomeMenuData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/neoforged/neoforge/items/ItemStackHandler;Lnet/minecraft/world/inventory/ContainerData;Learth/terrarium/tempad/common/menu/MetronomeMenuData;)V", "Ljava/util/Optional;", "(ILnet/minecraft/world/entity/player/Inventory;Ljava/util/Optional;)V", "getEnergy", "()Lnet/minecraft/world/inventory/ContainerData;", "getData", "()Learth/terrarium/tempad/common/menu/MetronomeMenuData;", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "index", "stillValid", "", "addPlayerInvSlots", "", "inventory", "x", "y", "addMenuSlots", "tempad-1.21.1"})
public final class MetronomeMenu
extends AbstractContainerMenu {
    @NotNull
    private final ContainerData energy;
    @Nullable
    private final MetronomeMenuData data;

    public MetronomeMenu(int id, @NotNull Inventory inv, @NotNull ItemStackHandler items, @NotNull ContainerData energy, @Nullable MetronomeMenuData data) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)energy, (String)"energy");
        super(ModMenus.INSTANCE.getMetronome(), id);
        this.energy = energy;
        this.data = data;
        MetronomeMenu.addMenuSlots$default(this, items, 0, 0, 6, null);
        MetronomeMenu.addPlayerInvSlots$default(this, inv, 0, 0, 6, null);
        this.addDataSlots(this.energy);
    }

    @NotNull
    public final ContainerData getEnergy() {
        return this.energy;
    }

    @Nullable
    public final MetronomeMenuData getData() {
        return this.data;
    }

    public MetronomeMenu(int id, @NotNull Inventory inv, @NotNull Optional<MetronomeMenuData> data) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(id, inv, new MetronomeItemHandler(), (ContainerData)new SimpleContainerData(2), (MetronomeMenuData)OptionalsKt.getOrNull(data));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack newStack = ItemStack.EMPTY;
        Object object = this.slots.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot slot = (Slot)object;
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (index < 8) {
                if (!this.moveItemStackTo(originalStack, 8, this.slots.size(), true)) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else if (!this.moveItemStackTo(originalStack, 0, 8, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        ItemStack itemStack = newStack;
        Intrinsics.checkNotNull((Object)itemStack);
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    private final void addPlayerInvSlots(Inventory inventory, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)inventory, column + row * 9 + 9, x + column * 18, y + row * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, x + k * 18, y + 54 + 4));
        }
    }

    static /* synthetic */ void addPlayerInvSlots$default(MetronomeMenu metronomeMenu, Inventory inventory, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 25;
        }
        if ((n3 & 4) != 0) {
            n2 = 85;
        }
        metronomeMenu.addPlayerInvSlots(inventory, n, n2);
    }

    private final void addMenuSlots(ItemStackHandler items, int x, int y) {
        for (int slot = 0; slot < 8; ++slot) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)items, slot, x + (slot + (slot > 3 ? 1 : 0)) * 18, y + 30));
        }
    }

    static /* synthetic */ void addMenuSlots$default(MetronomeMenu metronomeMenu, ItemStackHandler itemStackHandler, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 25;
        }
        if ((n3 & 4) != 0) {
            n2 = 10;
        }
        metronomeMenu.addMenuSlots(itemStackHandler, n, n2);
    }
}

