/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.location_handlers;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.locations.LocationGetter;
import earth.terrarium.tempad.api.locations.LocationHandler;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0096\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Learth/terrarium/tempad/common/location_handlers/WalletLocationHandler;", "Learth/terrarium/tempad/api/locations/LocationHandler;", "playerProfile", "Lcom/mojang/authlib/GameProfile;", "upgrades", "Learth/terrarium/tempad/api/tva_device/UpgradeHandler;", "chronons", "Learth/terrarium/tempad/api/tva_device/ChrononHandler;", "<init>", "(Lcom/mojang/authlib/GameProfile;Learth/terrarium/tempad/api/tva_device/UpgradeHandler;Learth/terrarium/tempad/api/tva_device/ChrononHandler;)V", "getPlayerProfile", "()Lcom/mojang/authlib/GameProfile;", "getUpgrades", "()Learth/terrarium/tempad/api/tva_device/UpgradeHandler;", "getChronons", "()Learth/terrarium/tempad/api/tva_device/ChrononHandler;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "locations", "", "Ljava/util/UUID;", "Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "getLocations", "()Ljava/util/Map;", "minusAssign", "", "locationId", "getSerializable", "Learth/terrarium/tempad/api/locations/LocationGetter;", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nWalletLocationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WalletLocationHandler.kt\nearth/terrarium/tempad/common/location_handlers/WalletLocationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class WalletLocationHandler
implements LocationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameProfile playerProfile;
    @NotNull
    private final UpgradeHandler upgrades;
    @NotNull
    private final ChrononHandler chronons;
    @NotNull
    private static final ResourceLocation id = TempadKt.getTempadId("wallet");
    @NotNull
    private static final UUID[] ids;

    public WalletLocationHandler(@NotNull GameProfile playerProfile, @NotNull UpgradeHandler upgrades, @NotNull ChrononHandler chronons) {
        Intrinsics.checkNotNullParameter((Object)playerProfile, (String)"playerProfile");
        Intrinsics.checkNotNullParameter((Object)upgrades, (String)"upgrades");
        Intrinsics.checkNotNullParameter((Object)chronons, (String)"chronons");
        this.playerProfile = playerProfile;
        this.upgrades = upgrades;
        this.chronons = chronons;
    }

    @NotNull
    public final GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    @NotNull
    public final UpgradeHandler getUpgrades() {
        return this.upgrades;
    }

    @NotNull
    public final ChrononHandler getChronons() {
        return this.chronons;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        MinecraftServer minecraftServer = Tempad.Companion.getServer();
        return minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null ? minecraftServer.getPlayer(this.playerProfile.getId()) : null;
    }

    @Override
    @NotNull
    public Map<UUID, NamedGlobalVec3> getLocations() {
        ServerPlayer serverPlayer = this.getPlayer();
        if (serverPlayer == null) {
            return MapsKt.emptyMap();
        }
        ServerPlayer player = serverPlayer;
        SyncableContext<?> syncableContext = ContextRegistry.INSTANCE.locate((Player)player, (Function1<? super ItemStack, Boolean>)((Function1)WalletLocationHandler::_get_locations_$lambda$0));
        if (syncableContext == null) {
            return MapsKt.emptyMap();
        }
        SyncableContext<?> wallet = syncableContext;
        Map values = new LinkedHashMap();
        ItemContainerContents walletContents = ModComponentsKt.getWalletContents((MutableDataComponentHolder)wallet.getStack());
        int n = walletContents.getSlots();
        for (int i2 = 0; i2 < n; ++i2) {
            NamedGlobalVec3 namedGlobalVec3;
            ItemStack itemStack = walletContents.getStackInSlot(i2);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            LocationGetter locationGetter = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)itemStack);
            if (locationGetter == null || (namedGlobalVec3 = locationGetter.get(this.upgrades, this.chronons)) == null) continue;
            NamedGlobalVec3 it = namedGlobalVec3;
            boolean bl = false;
            UUID uUID = ids[i2];
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"get(...)");
            values.put(uUID, it);
        }
        return values;
    }

    @Override
    public void minusAssign(@NotNull UUID locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
    }

    @Override
    @Nullable
    public LocationGetter getSerializable(@NotNull UUID locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _get_locations_$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.is(ModItems.INSTANCE.getCardWallet())) return false;
        Iterable iterable = ModComponentsKt.getWalletContents((MutableDataComponentHolder)it).nonEmptyItems();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
        if (CollectionsKt.count((Iterable)iterable) <= 0) return false;
        return true;
    }

    static {
        UUID[] uUIDArray = new UUID[]{UUID.fromString("d15655c9-782d-4a21-9f7e-024522cc5c52"), UUID.fromString("fefeb329-cd83-492b-a279-96305f85e07d"), UUID.fromString("b8de7ee0-b175-4785-8cef-02f107fac7b8"), UUID.fromString("f92bbcbe-5da5-462e-bdd5-d2cdb73f2f91"), UUID.fromString("d611b84e-a2ed-46b4-9b43-f61a7121b506"), UUID.fromString("407ed827-e56c-453e-8f55-7e5c7b49b9bb"), UUID.fromString("e8516d35-9943-41c5-bd9c-23678aa27e1e"), UUID.fromString("fd9cb781-9cd4-4975-bfc1-5c388d442c26"), UUID.fromString("af1796b9-ab87-4799-9e62-c804f9898cf8"), UUID.fromString("dec5a3b2-bd0e-4fe8-9222-01a486b329ad"), UUID.fromString("fa5c3767-3624-4ab2-9530-360adc73949f"), UUID.fromString("ff0cd8d6-b1f0-4a26-8900-ed70dbd97dc9"), UUID.fromString("381dd934-33e9-4b45-968b-39329bc2358c"), UUID.fromString("7ad6a4f9-b9f5-4e0d-a6dd-78e8a7bd67e7"), UUID.fromString("b37db112-ac1b-4f73-b2a2-99b47769467d"), UUID.fromString("36352a51-eb4e-4639-b7aa-8848a84a516f"), UUID.fromString("874dc1fb-b4f4-4828-a2a0-fc2f2cbabedf"), UUID.fromString("d9885d96-0aed-47ad-9ec0-9483b0d25a90")};
        ids = uUIDArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Learth/terrarium/tempad/common/location_handlers/WalletLocationHandler$Companion;", "", "<init>", "()V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "ids", "", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "[Ljava/util/UUID;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getId() {
            return id;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

