/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.client.tooltip.ChrononToolipKt;
import earth.terrarium.tempad.common.block.MetronomeBe;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Learth/terrarium/tempad/common/items/MetronomeItem;", "Lnet/minecraft/world/item/BlockItem;", "<init>", "()V", "updateCustomBlockEntityTag", "", "pos", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "tempad-1.21.1"})
public final class MetronomeItem
extends BlockItem {
    public MetronomeItem() {
        super((Block)ModBlocks.INSTANCE.getMetronome(), new Item.Properties().stacksTo(1));
    }

    protected boolean updateCustomBlockEntityTag(@NotNull BlockPos pos, @NotNull Level level, @Nullable Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity == null) break block2;
            BlockEntity blockEntity2 = blockEntity;
            boolean bl = false;
            if (blockEntity2 instanceof MetronomeBe) {
                Player player2 = player;
                if (player2 != null) {
                    Player it = player2;
                    boolean bl2 = false;
                    ((MetronomeBe)blockEntity2).setOwner(it.getGameProfile());
                    ((MetronomeBe)blockEntity2).setInitialChronons(ModComponentsKt.getChrononContent((MutableDataComponentHolder)stack));
                }
            }
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
        Optional<TooltipComponent> optional = Optional.ofNullable(chrononHandler != null ? ChrononToolipKt.getTooltip(chrononHandler) : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }
}

