/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.compat;

import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.common.entity.TimedoorEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Learth/terrarium/tempad/common/compat/TimedoorComponentProvider;", "Lsnownee/jade/api/IEntityComponentProvider;", "<init>", "()V", "getUid", "Lnet/minecraft/resources/ResourceLocation;", "appendTooltip", "", "tooltip", "Lsnownee/jade/api/ITooltip;", "accessor", "Lsnownee/jade/api/EntityAccessor;", "config", "Lsnownee/jade/api/config/IPluginConfig;", "tempad-1.21.1"})
public final class TimedoorComponentProvider
implements IEntityComponentProvider {
    @NotNull
    public static final TimedoorComponentProvider INSTANCE = new TimedoorComponentProvider();

    private TimedoorComponentProvider() {
    }

    @NotNull
    public ResourceLocation getUid() {
        return TempadKt.getTempadId("timedoor");
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull EntityAccessor accessor, @NotNull IPluginConfig config) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Entity entity = accessor.getEntity();
        TimedoorEntity timedoorEntity = entity instanceof TimedoorEntity ? (TimedoorEntity)entity : null;
        if (timedoorEntity == null) {
            return;
        }
        TimedoorEntity timedoorEntity2 = timedoorEntity;
        if (timedoorEntity2.getClosingTime() - 5 > 0) {
            objectArray = new Object[]{MathKt.roundToInt((float)((float)timedoorEntity2.getClosingTime() / 20.0f))};
            tooltip.add((Component)Component.translatable((String)"jade.tempad.will_close", (Object[])objectArray));
        } else if (timedoorEntity2.getClosingTime() != -1) {
            tooltip.add((Component)Component.translatable((String)"jade.tempad.closing"));
        }
        objectArray = new Object[]{Component.translatable((String)timedoorEntity2.getTargetDimension().location().toLanguageKey("dimension")), (int)timedoorEntity2.getTargetPos().x() + ", " + (int)timedoorEntity2.getTargetPos().y() + ", " + (int)timedoorEntity2.getTargetPos().z()};
        tooltip.add((Component)Component.translatable((String)"jade.tempad.pos", (Object[])objectArray));
    }
}

