/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.devices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class VanillaCraftingDevice
implements ICraftingDevice {
    public static final ResourceLocation DEVICE_VANILLA_CRAFTING = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"vanilla_crafting");
    List<ItemStack> inventory = new ArrayList<ItemStack>();
    private ItemStack cardStack = ItemStack.EMPTY;
    private Recipe recipe;
    private int ticks = -1;

    @Override
    public ResourceLocation getID() {
        return DEVICE_VANILLA_CRAFTING;
    }

    @Override
    public void setupCraft(@Nonnull Level world, @Nonnull ItemStack cardStack) {
        this.cardStack = cardStack;
        this.recipe = CraftingCardItem.findRecipe((Level)world, (ItemStack)cardStack, this.getRecipeType());
    }

    @Override
    public List<Ingredient> getIngredients() {
        if (this.recipe != null) {
            return this.recipe.getIngredients();
        }
        return Collections.emptyList();
    }

    @Override
    public void tick() {
        if (this.ticks > 0) {
            --this.ticks;
        }
    }

    @Override
    public boolean insertIngredients(Level world, List<ItemStack> items) {
        if (this.recipe == null) {
            return false;
        }
        if (this.getStatus() != ICraftingDevice.Status.IDLE) {
            return false;
        }
        this.inventory.clear();
        for (ItemStack item : items) {
            this.inventory.add(item);
        }
        CraftingInput.Positioned inp = CraftingInput.ofPositioned((int)3, (int)3, this.inventory);
        if (!this.recipe.matches((RecipeInput)inp.input(), world)) {
            this.inventory.clear();
            return false;
        }
        this.ticks = 10;
        return true;
    }

    @Override
    public ItemStack getCraftingItem(Level level) {
        CraftingInput.Positioned inp = CraftingInput.ofPositioned((int)3, (int)3, this.inventory);
        return BaseRecipe.assemble((Recipe)this.recipe, (RecipeInput)inp.input(), (Level)level);
    }

    @Override
    public List<ItemStack> extractOutput(Level level) {
        if (this.getStatus() == ICraftingDevice.Status.READY) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            this.ticks = -1;
            CraftingInput.Positioned inp = CraftingInput.ofPositioned((int)3, (int)3, this.inventory);
            ItemStack rc = BaseRecipe.assemble((Recipe)this.recipe, (RecipeInput)inp.input(), (Level)level);
            if (!rc.isEmpty()) {
                result.add(rc);
            }
            for (Object item : this.recipe.getRemainingItems((RecipeInput)inp.input())) {
                result.add((ItemStack)item);
            }
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, ItemStack.EMPTY);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ICraftingDevice.Status getStatus() {
        if (this.ticks == -1) {
            return ICraftingDevice.Status.IDLE;
        }
        if (this.ticks == 0) {
            return ICraftingDevice.Status.READY;
        }
        return ICraftingDevice.Status.BUSY;
    }

    @Override
    public RecipeType<?> getRecipeType() {
        return RecipeType.CRAFTING;
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        this.cardStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("cardStack"));
        this.ticks = tag.getInt("ticks");
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        tag.putInt("ticks", this.ticks);
        CompoundTag compoundNBT = new CompoundTag();
        Tag stackTag = this.cardStack.save(provider, (Tag)compoundNBT);
        tag.put("cardStack", stackTag);
    }
}

