/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.rftoolsstorage.craftinggrid.IItemKey;
import mcjty.rftoolsstorage.craftinggrid.IItemSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoriesItemSource
implements IItemSource {
    private final List<Pair<IItemHandler, Integer>> inventories = new ArrayList<Pair<IItemHandler, Integer>>();

    public InventoriesItemSource add(IItemHandler inventory, int offset) {
        this.inventories.add((Pair<IItemHandler, Integer>)Pair.of((Object)inventory, (Object)offset));
        return this;
    }

    @Override
    public Iterable<Pair<IItemKey, ItemStack>> getItems() {
        return () -> new Iterator<Pair<IItemKey, ItemStack>>(){
            private int inventoryIndex = 0;
            private int slotIndex = 0;

            private boolean firstValidItem() {
                while (this.inventoryIndex < InventoriesItemSource.this.inventories.size()) {
                    IItemHandler inventory = (IItemHandler)InventoriesItemSource.this.inventories.get(this.inventoryIndex).getLeft();
                    int offset = (Integer)InventoriesItemSource.this.inventories.get(this.inventoryIndex).getRight();
                    if (this.slotIndex < offset) {
                        this.slotIndex = offset;
                    }
                    if (this.slotIndex < inventory.getSlots()) {
                        return true;
                    }
                    this.slotIndex = 0;
                    ++this.inventoryIndex;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.firstValidItem();
            }

            @Override
            public Pair<IItemKey, ItemStack> next() {
                IItemHandler inventory = (IItemHandler)InventoriesItemSource.this.inventories.get(this.inventoryIndex).getLeft();
                ItemKey key = new ItemKey(inventory, this.slotIndex);
                Pair result = Pair.of((Object)key, (Object)inventory.getStackInSlot(this.slotIndex));
                ++this.slotIndex;
                return result;
            }
        };
    }

    @Override
    public ItemStack decrStackSize(IItemKey key, int amount) {
        ItemKey realKey = (ItemKey)key;
        ItemStack stack = realKey.inventory().getStackInSlot(realKey.slot());
        ItemStack result = stack.split(amount);
        if (stack.isEmpty()) {
            // empty if block
        }
        return result;
    }

    @Override
    public boolean insertStack(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        IItemHandler inventory = realKey.inventory();
        ItemStack origStack = inventory.extractItem(realKey.slot(), 64, false);
        if (!origStack.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)origStack, (ItemStack)stack)) {
                if (stack.getCount() + origStack.getCount() > stack.getMaxStackSize()) {
                    return false;
                }
                stack.grow(origStack.getCount());
            } else {
                return false;
            }
        }
        inventory.insertItem(realKey.slot(), stack, false);
        return true;
    }

    @Override
    public int insertStackAnySlot(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        IItemHandler inventory = realKey.inventory();
        return 0;
    }

    private record ItemKey(IItemHandler inventory, int slot) implements IItemKey
    {
    }
}

