/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CraftingGridInventory
implements IItemHandlerModifiable {
    public static final int SLOT_GHOSTOUTPUT = 0;
    public static final int SLOT_GHOSTINPUT = 1;
    public static final int GRID_WIDTH = 66;
    public static final int GRID_HEIGHT = 208;
    public static final int GRID_XOFFSET = -61;
    public static final int GRID_YOFFSET = 127;
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();
    public static final Codec<CraftingGridInventory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("stacks").forGetter(s -> s.stacks)).apply((Applicative)instance, CraftingGridInventory::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingGridInventory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, s -> s.stacks, CraftingGridInventory::new);

    public ItemStack getResult() {
        return this.stacks.get(0);
    }

    public CraftingGridInventory() {
    }

    public CraftingGridInventory(List<ItemStack> stacks) {
        this.stacks.clear();
        this.stacks.addAll(stacks);
        while (this.stacks.size() < 10) {
            this.stacks.add(ItemStack.EMPTY);
        }
    }

    public void set(CraftingGridInventory inventory) {
        this.stacks.clear();
        this.stacks.addAll(inventory.stacks);
        while (this.stacks.size() < 10) {
            this.stacks.add(ItemStack.EMPTY);
        }
    }

    public ItemStack[] getIngredients() {
        ItemStack[] ing = new ItemStack[9];
        for (int i = 0; i < ing.length; ++i) {
            ing[i] = this.stacks.get(i + 1);
        }
        return ing;
    }

    public int getSlots() {
        return 10;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        while (this.stacks.size() < 10) {
            this.stacks.add(ItemStack.EMPTY);
        }
        this.stacks.set(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack getStackInSlot(int index) {
        return index < this.stacks.size() ? this.stacks.get(index) : ItemStack.EMPTY;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftingGridInventory that = (CraftingGridInventory)o;
        return this.stacks.equals(that.stacks);
    }

    public int hashCode() {
        return this.stacks.hashCode();
    }
}

