/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.data.StorageModuleData;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CommandRestore
implements Command<CommandSourceStack> {
    private static final CommandRestore CMD = new CommandRestore();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"restore").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String uuidString = (String)context.getArgument("uuid", String.class);
        ItemStack stack = ((CommandSourceStack)context.getSource()).getPlayerOrException().getMainHandItem();
        if (!(stack.getItem() instanceof StorageModuleItem)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal((String)"Keep a storage module in your main hand!").withStyle(style -> style.applyFormat(ChatFormatting.RED)), true);
            return 0;
        }
        int maxSize = StorageModuleItem.getSize(stack);
        StorageHolder holder = StorageHolder.get((Level)((CommandSourceStack)context.getSource()).getLevel());
        StorageEntry foundEntry = null;
        for (StorageEntry storage : holder.getStorages()) {
            if (!storage.getUuid().toString().startsWith(uuidString)) continue;
            if (foundEntry != null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal((String)"Multiple storage entries match this UUID part!").withStyle(style -> style.applyFormat(ChatFormatting.RED)), true);
                return 0;
            }
            foundEntry = storage;
        }
        if (foundEntry != null) {
            if (foundEntry.getStacks().size() != maxSize) {
                StorageEntry finalFoundEntry = foundEntry;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal((String)("Wrong foundEntry module tier! " + finalFoundEntry.getStacks().size() + " stacks are required!")).withStyle(style -> style.applyFormat(ChatFormatting.RED)), true);
            } else {
                StorageModuleData data = StorageModuleItem.getData(stack).withUuid(foundEntry.getUuid());
                stack.set((DataComponentType)ModularStorageModule.ITEM_STORAGE_MODULE_DATA.get(), (Object)data);
                ((CommandSourceStack)context.getSource()).getPlayerOrException().inventoryMenu.broadcastChanges();
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal((String)("No storage found with UUID " + uuidString)).withStyle(style -> style.applyFormat(ChatFormatting.RED)), true);
        }
        return 0;
    }
}

