/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets;

import java.util.Objects;
import org.joml.Vector2f;

public class MutableRectangle {
    public float x;
    public float y;
    public float width;
    public float height;

    public MutableRectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public MutableRectangle nudge(float xOffset, float yOffset) {
        this.x += xOffset;
        this.width += xOffset;
        this.y += yOffset;
        this.height += yOffset;
        return this;
    }

    public Vector2f halfSize() {
        return new Vector2f(this.width / 2.0f, this.height / 2.0f);
    }

    public Vector2f midpoint() {
        return new Vector2f(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public MutableRectangle toScreen(float xOffset, float yOffset) {
        return new MutableRectangle(this.x + xOffset, this.y + yOffset, this.x + xOffset + this.width, this.y + yOffset + this.height);
    }

    public boolean contains(float x, float y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public static MutableRectangle supplier(int i) {
        return new MutableRectangle(i, i, i, i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableRectangle that = (MutableRectangle)o;
        if (Float.compare(that.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(that.y, this.y) != 0) {
            return false;
        }
        if (Float.compare(that.width, this.width) != 0) {
            return false;
        }
        return Float.compare(that.height, this.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return "[%s, %s, %s, %s]".formatted(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }
}

