/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.item2;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;

public record ItemContainerToVanillaAdapter(IResourceContainer<ItemResource> itemContainer) implements Container
{
    public int getContainerSize() {
        return this.itemContainer.size();
    }

    public boolean isEmpty() {
        return this.itemContainer.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        MutableResourceStack<ItemResource> resourceStack = this.itemContainer.get(slot);
        return resourceStack.resource().toStack(resourceStack.amount());
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getItem(slot);
        ItemStack split = stack.split(amount);
        this.itemContainer.set(slot, MutableResourceStack.of(ItemResource.of(stack), stack.getCount()));
        return split;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(slot);
        this.itemContainer.set(slot, MutableResourceStack.Empty.ITEM);
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.itemContainer.set(slot, MutableResourceStack.of(ItemResource.of(stack), stack.getCount()));
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.itemContainer.clear();
    }
}

