/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.energy;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.energy.EnergyContainerSlice;
import tv.soaryn.xycraft.core.container.energy.EnergyContainerToHandlerAdapter;
import tv.soaryn.xycraft.core.utils.handlers.HandlerIOBehavior;
import tv.soaryn.xycraft.core.utils.protocontainer.energy.IEnergyHandler;

public interface EnergyContainer
extends IntIterable {
    @Contract(pure=true)
    public int size();

    @Contract(pure=true)
    public int getCapacity(int var1);

    @Contract(pure=true)
    default public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) <= 0) continue;
            return false;
        }
        return true;
    }

    default public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, 0);
        }
    }

    public int get(int var1);

    public void set(int var1, int var2);

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    default public EnergyContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new EnergyContainerSlice(this, from, to - from);
    }

    @Contract(pure=true)
    default public int @NotNull [] copyContents() {
        int[] array = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @NotNull
    @Contract(value="-> new", pure=true)
    default public IntIterator iterator() {
        return new IntIterator(){
            final int size;
            int i;
            {
                this.size = EnergyContainer.this.size();
                this.i = 0;
            }

            public boolean hasNext() {
                return this.i < this.size;
            }

            public int nextInt() {
                return EnergyContainer.this.get(this.i++);
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    default public IEnergyHandler.IEnergyHandlerModifiable asHandler() {
        return this.asHandler(HandlerIOBehavior.DEFAULT);
    }

    @Contract(pure=true)
    @NotNull
    default public IEnergyHandler.IEnergyHandlerModifiable asHandler(HandlerIOBehavior behavior) {
        return new EnergyContainerToHandlerAdapter(this, behavior);
    }
}

