/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import tv.soaryn.xycraft.core.XyCore;

public interface CoreRenderTypes {
    public static RenderType laser(ResourceLocation texture) {
        return Internal.Laser.apply(texture);
    }

    public static RenderType laserNode(ResourceLocation texture) {
        return Internal.LaserNode.apply(texture);
    }

    public static RenderType icosphere(ResourceLocation texture) {
        return Internal.Icosphere.apply(texture);
    }

    public static class Internal
    extends RenderType {
        public static ShaderInstance laserShader;
        public static ShaderInstance laserNodeShader;
        public static ShaderInstance icosphereShader;
        private static final RenderStateShard.ShaderStateShard LaserRenderType;
        private static final RenderStateShard.ShaderStateShard LaserNodeRenderType;
        private static final RenderStateShard.ShaderStateShard IcosphereRenderType;
        public static final Function<ResourceLocation, RenderType> Laser;
        public static final Function<ResourceLocation, RenderType> LaserNode;
        public static final Function<ResourceLocation, RenderType> Icosphere;

        private Internal(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        private static RenderType laser(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setShaderState(LaserRenderType).setTextureState(RenderStateShard.NO_TEXTURE).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setOutputState(RenderStateShard.MAIN_TARGET).createCompositeState(true);
            return Internal.create((String)"xycraft_laser", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType laserNode(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setShaderState(LaserNodeRenderType).setTextureState(RenderStateShard.NO_TEXTURE).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setOutputState(RenderStateShard.MAIN_TARGET).createCompositeState(true);
            return Internal.create((String)"xycraft_laser_node", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$state);
        }

        private static RenderType icosphere(ResourceLocation locationIn) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.builder().setShaderState(IcosphereRenderType).setTextureState(RenderStateShard.NO_TEXTURE).setCullState(RenderStateShard.CULL).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).setOutputState(RenderStateShard.MAIN_TARGET).createCompositeState(true);
            return Internal.create((String)"xycraft_icosphere", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$state);
        }

        static {
            LaserRenderType = new RenderStateShard.ShaderStateShard(() -> laserShader);
            LaserNodeRenderType = new RenderStateShard.ShaderStateShard(() -> laserNodeShader);
            IcosphereRenderType = new RenderStateShard.ShaderStateShard(() -> icosphereShader);
            Laser = Util.memoize(Internal::laser);
            LaserNode = Util.memoize(Internal::laserNode);
            Icosphere = Util.memoize(Internal::icosphere);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="xycraft_core", bus=EventBusSubscriber.Bus.MOD)
    public static interface ModEvents {
        @SubscribeEvent
        public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), XyCore.resource("laser_node"), DefaultVertexFormat.BLOCK), shaderInstance -> {
                Internal.laserNodeShader = shaderInstance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), XyCore.resource("laser"), DefaultVertexFormat.BLOCK), shaderInstance -> {
                Internal.laserShader = shaderInstance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), XyCore.resource("icosphere"), DefaultVertexFormat.BLOCK), shaderInstance -> {
                Internal.icosphereShader = shaderInstance;
            });
        }
    }
}

