/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.content.pipes.examples;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.api.content.pipes.examples.BufferedPipeGraph;
import tv.soaryn.xycraft.core.utils.MathUtils;

public final class EnergyPipeGraph
extends BufferedPipeGraph<IEnergyStorage, EnergyPipeGraph> {
    public static final Codec<EnergyPipeGraph> CODEC = RecordCodecBuilder.create(builder -> PipeGraph.pipeGroup(builder, Capabilities.EnergyStorage.BLOCK).and(EnergyPipeGraph.bufferCodecRecord()).apply((Applicative)builder, EnergyPipeGraph::new));
    public static final AttachmentType.Builder<PipeNetwork<EnergyPipeGraph, IEnergyStorage>> NetworkBuilder = PipeNetwork.builder(CODEC, EnergyPipeGraph::new);
    private final ArrayList<Object2ObjectMap.Entry<IEnergyStorage, ObjectArraySet<PipeGroup<?>>>> _distributionList = new ArrayList();

    public EnergyPipeGraph(UUID uuid) {
        super(uuid, new PipeRoute(Capabilities.EnergyStorage.BLOCK));
    }

    public EnergyPipeGraph(UUID uuid, PipeRoute<IEnergyStorage> pipeRoute, Set<PipeGroup<IEnergyStorage>> serializedBuffers) {
        super(uuid, pipeRoute, serializedBuffers);
    }

    @Override
    public long getDemand(IEnergyStorage handler) {
        return handler.canReceive() ? (long)handler.receiveEnergy(Integer.MAX_VALUE, true) : 0L;
    }

    @Override
    protected long getMinimumBuffer() {
        return 0L;
    }

    @Override
    public void distribute(Object2ObjectOpenHashMap<IEnergyStorage, ObjectArraySet<PipeGroup<?>>> receiverGroup) {
        if (receiverGroup.isEmpty()) {
            return;
        }
        this._distributionList.addAll((Collection<Object2ObjectMap.Entry<IEnergyStorage, ObjectArraySet<PipeGroup<?>>>>)receiverGroup.object2ObjectEntrySet());
        Collections.shuffle(this._distributionList);
        for (Object2ObjectMap.Entry<IEnergyStorage, ObjectArraySet<PipeGroup<?>>> entry : this._distributionList) {
            IEnergyStorage cap = (IEnergyStorage)entry.getKey();
            ObjectArraySet buffers = (ObjectArraySet)entry.getValue();
            long sum = 0L;
            for (PipeGroup pipeGroup : buffers) {
                long pipeGroupStored = pipeGroup.getStored();
                sum += pipeGroupStored;
            }
            int stored = MathUtils.toInt(sum);
            int amountAbsorbed = cap.receiveEnergy(stored, false);
            for (PipeGroup buffer : buffers) {
                long handled = Math.min(buffer.Stored, (long)amountAbsorbed);
                buffer.Stored -= handled;
                amountAbsorbed -= MathUtils.toInt(handled);
            }
        }
        this._distributionList.clear();
    }
}

