/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightRangeFilter
extends PlacementFilter {
    public static final MapCodec<HeightRangeFilter> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)VerticalProvider.CODEC.listOf().optionalFieldOf("below", List.of()).forGetter(p -> p.below), (App)VerticalProvider.CODEC.listOf().optionalFieldOf("above", List.of()).forGetter(p -> p.above)).apply((Applicative)i, HeightRangeFilter::new));
    private final List<VerticalProvider> below;
    private final List<VerticalProvider> above;

    private HeightRangeFilter(List<VerticalProvider> below, List<VerticalProvider> above) {
        this.below = below;
        this.above = above;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        int limitY;
        for (VerticalProvider provider : this.below) {
            limitY = provider.resolveY(context, pos.getX(), pos.getZ());
            if (pos.getY() <= limitY) continue;
            return false;
        }
        for (VerticalProvider provider : this.above) {
            limitY = provider.resolveY(context, pos.getX(), pos.getZ());
            if (pos.getY() >= limitY) continue;
            return false;
        }
        return true;
    }

    public PlacementModifierType<?> type() {
        return MoonlightRegistry.HEIGHT_RANGE.get();
    }

    private static interface VerticalProvider {
        public static final CodecMapRegistry<VerticalProvider> REG = (CodecMapRegistry)Util.make(() -> {
            CodecMapRegistry reg = new CodecMapRegistry("vertical_providers");
            reg.register("anchor", Anchor.CODEC);
            reg.register("sea_level", SeaLevelAnchor.CODEC);
            reg.register("heightmap", HeightmapAnchor.CODEC);
            return reg;
        });
        public static final Codec<VerticalProvider> CODEC = REG.dispatch(VerticalProvider::getCodec);

        public int resolveY(PlacementContext var1, int var2, int var3);

        public MapCodec<? extends VerticalProvider> getCodec();
    }

    public record HeightmapAnchor(Heightmap.Types heightmap, int offset) implements VerticalProvider
    {
        public static final MapCodec<HeightmapAnchor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(HeightmapAnchor::heightmap), (App)Codec.INT.fieldOf("offset").forGetter(HeightmapAnchor::offset)).apply((Applicative)instance, HeightmapAnchor::new));

        @Override
        public int resolveY(PlacementContext context, int x, int z) {
            return context.getHeight(this.heightmap, x, z) + this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " from heightmap " + String.valueOf(this.heightmap);
        }

        public MapCodec<HeightmapAnchor> getCodec() {
            return CODEC;
        }
    }

    public record SeaLevelAnchor(int offset) implements VerticalProvider
    {
        public static final MapCodec<SeaLevelAnchor> CODEC = Codec.INT.fieldOf("offset").xmap(SeaLevelAnchor::new, SeaLevelAnchor::offset);

        @Override
        public int resolveY(PlacementContext context, int x, int z) {
            return context.getLevel().getSeaLevel() + this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " from sea level";
        }

        public MapCodec<SeaLevelAnchor> getCodec() {
            return CODEC;
        }
    }

    public record Anchor(VerticalAnchor anchor) implements VerticalProvider
    {
        public static final MapCodec<Anchor> CODEC = VerticalAnchor.CODEC.fieldOf("anchor").xmap(Anchor::new, Anchor::anchor);

        @Override
        public int resolveY(PlacementContext context, int x, int z) {
            return this.anchor.resolveY((WorldGenerationContext)context);
        }

        @Override
        public String toString() {
            return this.anchor.toString();
        }

        public MapCodec<Anchor> getCodec() {
            return CODEC;
        }
    }
}

