/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.misc.CircularList;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;

public class BackCommand {
    private static final int MAX_HISTORY = 10;
    private static final WeakHashMap<ServerPlayer, CircularList<GlobalPos>> HISTORY = new WeakHashMap();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"back").requires(p -> p.hasPermission(2))).executes(BackCommand::teleportBack);
    }

    public static void onTeleported(Entity entity, BlockPos oldPos, ResourceKey<Level> oldDim) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CircularList list = HISTORY.computeIfAbsent(player, p -> new CircularList(10));
        GlobalPos previousPos = GlobalPos.of(oldDim, (BlockPos)oldPos);
        if (list.isEmpty() || !((GlobalPos)list.getLast()).equals((Object)previousPos)) {
            list.add(previousPos);
        }
    }

    private static int teleportBack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.translatable((String)"commands.moonlight.back.only_players"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CircularList<GlobalPos> list = HISTORY.get(player);
        if (list == null || list.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.moonlight.back.empty"));
            return 0;
        }
        GlobalPos last = (GlobalPos)list.removeLast();
        ServerLevel targetLevel = source.getServer().getLevel(last.dimension());
        if (targetLevel == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.moonlight.back.invalid_dimension"));
            return 0;
        }
        BlockPos pos = last.pos();
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        EnumSet<RelativeMovement> set = EnumSet.of(RelativeMovement.X_ROT, RelativeMovement.Y_ROT);
        BackCommand.performTeleport(source, (Entity)player, targetLevel, x, y, z, set);
        source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.single", (Object[])new Object[]{player.getDisplayName(), BackCommand.formatDouble(x), BackCommand.formatDouble(y), BackCommand.formatDouble(z)}), true);
        return 1;
    }

    private static void performTeleport(CommandSourceStack source, Entity entity, ServerLevel level, double x, double y, double z, Set<RelativeMovement> relativeList) throws CommandSyntaxException {
        float g;
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            throw new CommandSyntaxException(null, (Message)Component.translatable((String)"commands.teleport.invalidPosition"));
        }
        float f = Mth.wrapDegrees((float)entity.getYRot());
        if (entity.teleportTo(level, x, y, z, relativeList, f, g = Mth.wrapDegrees((float)entity.getXRot()))) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isFallFlying()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                entity.setOnGround(true);
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                pathfinderMob.getNavigation().stop();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

