/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class SimpleSpecialModelsLoader
extends SimplePreparableReloadListener<Void> {
    private final List<ResourceLocation> specialModels = new ArrayList<ResourceLocation>();

    protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        this.specialModels.clear();
        Gson gson = new Gson();
        String name = "models/special_models";
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)name);
        Map resourceLocationResourceMap = fileToIdConverter.listMatchingResources(resourceManager);
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry entry : resourceLocationResourceMap.entrySet()) {
            try {
                JsonObject jo;
                String mod;
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonElement.class);
                if (jsonelement instanceof JsonObject && (mod = GsonHelper.getAsString((JsonObject)(jo = (JsonObject)jsonelement), (String)"required_mod", null)) != null && PlatHelper.isModLoaded(mod)) {
                    continue;
                }
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Couldn't parse special model file {}:", entry.getKey(), (Object)e);
            }
            toRemove.add((ResourceLocation)entry.getKey());
        }
        this.specialModels.addAll(toRemove.stream().map(s -> s.withPath(s.getPath().substring(7, s.getPath().length() - 5))).toList());
        return null;
    }

    protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
    }

    public Iterable<ResourceLocation> getSpecialModels() {
        return this.specialModels;
    }
}

