/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FastSearchPathPackResources
extends AbstractPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;
    private final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    private final PackType packType;

    public FastSearchPathPackResources(PackLocationInfo location, Path root, PackType packType) {
        super(location);
        this.root = root;
        this.packType = packType;
        this.buildIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex() {
        Stopwatch watch = Stopwatch.createStarted();
        Path base = this.root.resolve(this.packType.getDirectory());
        if (!Files.exists(base, new LinkOption[0])) {
            Moonlight.LOGGER.info("Pack at {} does not contain {}, skipping index", (Object)this.root, (Object)this.packType.getDirectory());
            return;
        }
        try (Stream<Path> stream = Files.find(base, Integer.MAX_VALUE, (p, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);){
            stream.forEach(file -> {
                String rel = base.relativize((Path)file).toString().replace('\\', '/');
                int slash = rel.indexOf(47);
                if (slash <= 0 || slash == rel.length() - 1) {
                    return;
                }
                String namespace = rel.substring(0, slash);
                String pathWithinNs = rel.substring(slash + 1);
                if (!ResourceLocation.isValidNamespace((String)namespace)) {
                    LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.root);
                    return;
                }
                ResourceLocation rl = ResourceLocation.tryBuild((String)namespace, (String)pathWithinNs);
                if (rl != null) {
                    this.searchTrie.insert(rl);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to build index for {}", (Object)base, (Object)e);
        }
        finally {
            Moonlight.LOGGER.info("Populated search tree for pack at {} in {}", (Object)this.root, (Object)watch);
        }
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        FileUtil.validatePath((String[])elements);
        Path path = FileUtil.resolvePath((Path)this.root, List.of(elements));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create((Path)path) : null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        if (this.packType != packType) {
            return null;
        }
        Path path = this.root.resolve(packType.getDirectory()).resolve(location.getNamespace());
        return FastSearchPathPackResources.getResource(location, path);
    }

    @Nullable
    public static IoSupplier<InputStream> getResource(ResourceLocation location, Path path) {
        return (IoSupplier)FileUtil.decomposePath((String)location.getPath()).mapOrElse(list -> {
            Path path2 = FileUtil.resolvePath((Path)path, (List)list);
            return FastSearchPathPackResources.returnFileIfExists(path2);
        }, error -> {
            LOGGER.error("Invalid path {}: {}", (Object)location, (Object)error.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path path) {
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create((Path)path) : null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
        if (packType != this.packType) {
            return;
        }
        this.searchTrie.search(namespace + "/" + path).forEach(resourceLocation -> {
            Path file = this.root.resolve(packType.getDirectory()).resolve(resourceLocation.getNamespace()).resolve(resourceLocation.getPath());
            if (Files.isRegularFile(file, new LinkOption[0])) {
                output.accept(resourceLocation, (Object)IoSupplier.create((Path)file));
            } else {
                LOGGER.warn("File not found or not regular: {} -> {}", resourceLocation, (Object)file);
            }
        });
    }

    public Set<String> getNamespaces(PackType packType) {
        if (packType != this.packType) {
            return Set.of();
        }
        return new HashSet<String>(this.searchTrie.listFolders(""));
    }

    public void close() {
    }
}

