/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.mehvahdjukaar.supplementaries.common.entities.data.SlimedData;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    protected LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Shadow
    public abstract boolean onClimbable();

    @Shadow
    public abstract boolean isSuppressingSlidingDownLadder();

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @ModifyReturnValue(method={"getJumpBoostPower()F"}, at={@At(value="RETURN")})
    private float suppl$checkOverencumbered(float original) {
        CommonConfigs.SlimedJumpMode mode;
        LivingEntity self;
        SlimedData data;
        MobEffectInstance effect = this.getEffect((Holder<MobEffect>)ModRegistry.OVERENCUMBERED.getHolder());
        if (effect != null && effect.getAmplifier() > 0) {
            original -= 0.1f;
        }
        if ((data = (SlimedData)ModEntities.SLIMED_DATA.getOrCreate((Object)(self = (LivingEntity)this))).isSlimed() && (mode = CommonConfigs.Tweaks.HINDERS_JUMP.get()).isOn(this.level())) {
            original -= 0.1f;
        }
        return original;
    }

    @Inject(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void suppl$checkOnRope(Vec3 motion, CallbackInfoReturnable<Vec3> info) {
        BlockState b;
        if (this.onClimbable() && CommonConfigs.Functional.ROPE_SLIDE.get().booleanValue() && (b = this.getBlockStateOn()).is(ModTags.FAST_FALL_ROPES)) {
            this.fallDistance = 0.0f;
            double x = Mth.clamp((double)motion.x, (double)-0.15f, (double)0.15f);
            double z = Mth.clamp((double)motion.z, (double)-0.15f, (double)0.15f);
            double y = motion.y();
            if (this.isSuppressingSlidingDownLadder() && y < 0.0 && this instanceof Player) {
                y = 0.0;
            }
            info.setReturnValue((Object)new Vec3(x, y, z));
        }
    }

    @Inject(method={"triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isUsingItem()Z")})
    private void suppl$eatFromLunchBasket(ItemStack stack, int amount, CallbackInfo ci, @Local(argsOnly=true) LocalRef<ItemStack> food) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(ModComponents.LUNCH_BASKET_CONTENT.get());
        if (data != null && data.canEatFrom()) {
            food.set((Object)data.getSelected());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void suppl$slimeTick(CallbackInfo ci) {
        LivingEntity le;
        SlimedData data;
        if (CommonConfigs.Tweaks.SLIMED_EFFECT.get().booleanValue() && (data = (SlimedData)ModEntities.SLIMED_DATA.getOrNull((Object)(le = (LivingEntity)this))) != null) {
            data.tick(le);
        }
    }
}

