/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class RoadSignStructure
extends Structure {
    public static final MapCodec<RoadSignStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RoadSignStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.fieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.fieldOf("max_y").forGetter(structure -> structure.maxY), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, RoadSignStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int minY;
    private final int maxY;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;
    private static final Set<Holder<Biome>> VALID_BIOMES = new WeakHashSet();

    public RoadSignStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int minY, int maxY, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.minY = minY;
        this.maxY = maxY;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public StructureType<?> type() {
        return ModWorldgen.ROAD_SIGN_STRUCTURE.get();
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        Optional<BlockPos> suitablePosition = this.getSuitablePosition(context);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        BlockPos blockPos = suitablePosition.get();
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)3, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)32, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    private Optional<BlockPos> getSuitablePosition(Structure.GenerationContext context) {
        int z;
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator generator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState randomState = context.randomState();
        Set biomes = context.biomeSource().possibleBiomes();
        boolean hasVillages = false;
        for (Holder<Biome> v : VALID_BIOMES) {
            if (!biomes.contains(v)) continue;
            hasVillages = true;
            break;
        }
        if (!hasVillages) {
            return Optional.empty();
        }
        int x = chunkPos.getMiddleBlockX();
        int y = generator.getFirstOccupiedHeight(x, z = chunkPos.getMiddleBlockZ(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
        if (y < this.minY || y > this.maxY) {
            return Optional.empty();
        }
        if (y < generator.getSeaLevel()) {
            return Optional.empty();
        }
        IntArrayList list = new IntArrayList();
        list.add(y);
        if (RoadSignStructure.isPosNotValid(generator, x + 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (RoadSignStructure.isPosNotValid(generator, x + 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (RoadSignStructure.isPosNotValid(generator, x - 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (RoadSignStructure.isPosNotValid(generator, x - 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        IntRBTreeSet set = new IntRBTreeSet((IntCollection)list);
        if (set.lastInt() - set.firstInt() > 1) {
            return Optional.empty();
        }
        int sum = 0;
        for (Integer v : list) {
            sum += v.intValue();
        }
        return Optional.of(new BlockPos(x, Math.round((float)sum / 5.0f) + 1, z));
    }

    private static boolean isPosNotValid(ChunkGenerator gen, int x, int z, IntList heightMap, LevelHeightAccessor heightLimitView, RandomState randomState) {
        int y = gen.getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, randomState);
        NoiseColumn noisecolumn = gen.getBaseColumn(x, z, heightLimitView, randomState);
        BlockState state = noisecolumn.getBlock(y);
        try {
            if (state.getFluidState().isEmpty()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void recomputeValidStructureCache(RegistryAccess access) {
        for (Holder s : access.registryOrThrow(Registries.STRUCTURE).getTagOrEmpty(ModTags.ROAD_SIGN_DESTINATIONS)) {
            VALID_BIOMES.addAll(((Structure)s.value()).biomes().stream().toList());
        }
    }

    public static void clearCache() {
        VALID_BIOMES.clear();
    }

    public static class Type
    implements StructureType<RoadSignStructure> {
        public MapCodec<RoadSignStructure> codec() {
            return CODEC;
        }
    }
}

