/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainerView
implements TooltipProvider {
    public static final Codec<MobContainerView> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobContainer.MobData.CODEC.forGetter(v -> v.inner.getData()), (App)Codec.FLOAT.fieldOf("width").forGetter(v -> Float.valueOf(v.inner.getWidth())), (App)Codec.FLOAT.fieldOf("height").forGetter(v -> Float.valueOf(v.inner.getHeight())), (App)Codec.BOOL.fieldOf("aquarium").forGetter(v -> v.inner.isAquarium())).apply((Applicative)instance, MobContainerView::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobContainerView> STREAM_CODEC = StreamCodec.composite(MobContainer.MobData.STREAM_CODEC, v -> v.inner.getData(), (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.inner.getWidth()), (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.inner.getHeight()), (StreamCodec)ByteBufCodecs.BOOL, v -> v.inner.isAquarium(), MobContainerView::new);
    private final MobContainer inner;

    private MobContainerView(@NotNull MobContainer.MobData data, float width, float height, boolean aquarium) {
        this.inner = new MobContainer(width, height, aquarium);
        this.inner.setData((MobContainer.MobData)Preconditions.checkNotNull((Object)data, (Object)"cannot create mob container view with null data"));
    }

    private MobContainerView(MobContainer container) {
        this.inner = container.makeCopy();
    }

    @Nullable
    public MobContainerView copyWithNewUUID(UUID newUUID) {
        MobContainer.MobData mobData = this.inner.getData();
        if (mobData instanceof MobContainer.MobData.Entity) {
            MobContainer.MobData.Entity e = (MobContainer.MobData.Entity)mobData;
            return new MobContainerView(e.copyWithNewUUID(newUUID), this.inner.getWidth(), this.inner.getHeight(), this.inner.isAquarium());
        }
        return null;
    }

    public static MobContainerView of(MobContainer container) {
        Preconditions.checkNotNull((Object)container.getData(), (Object)"cannot create mob container view with null container");
        return new MobContainerView(container.makeCopy());
    }

    public int getFishTexture() {
        return this.inner.getData().getFishTexture();
    }

    public Holder<SoftFluid> getVisualFluid() {
        return this.inner.getData().getVisualFluid();
    }

    public void apply(MobContainer mobContainer) {
        mobContainer.setData(this.inner.getData());
    }

    public Entity getVisualEntity(Level level) {
        return this.inner.getDisplayedMob(level, null);
    }

    public float getRenderScale() {
        return ((MobContainer.MobData.Entity)this.inner.getData()).getScale();
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        String name = this.inner.getData().getName();
        if (name != null) {
            tooltipAdder.accept((Component)Component.translatable((String)name).withStyle(ChatFormatting.GRAY));
        }
    }

    public MobContainer.MobData getDataUnsafe() {
        return this.inner.getData();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MobContainerView) {
            MobContainerView other = (MobContainerView)obj;
            return this.inner.getData().equals(other.inner.getData());
        }
        return false;
    }

    public int hashCode() {
        return this.inner.getData().hashCode();
    }
}

