/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record FluteTargets(Set<Pet> pets) implements TooltipProvider
{
    public static final Codec<FluteTargets> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Pet.CODEC.listOf().fieldOf("pets").forGetter(f -> f.pets.stream().toList())).apply((Applicative)instance, a -> new FluteTargets(Set.copyOf(a))));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluteTargets> STREAM_CODEC = StreamCodec.composite((StreamCodec)Pet.STREAM_CODEC.apply(ByteBufCodecs.list()), f -> f.pets.stream().toList(), a -> new FluteTargets(Set.copyOf(a)));

    public static FluteTargets of(Entity target) {
        return new FluteTargets(Set.of(Pet.of(target)));
    }

    public FluteTargets andAdd(Entity target) {
        ArrayList<Pet> newPets = new ArrayList<Pet>(List.copyOf(this.pets));
        newPets.add(Pet.of(target));
        return new FluteTargets(Set.copyOf(newPets));
    }

    public int size() {
        return this.pets.size();
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        for (Pet pet : this.pets) {
            pet.addToTooltip(context, tooltipAdder, tooltipFlag);
        }
    }

    public Collection<Entity> getEntities(ServerLevel serverLevel) {
        return this.pets.stream().map(pet -> serverLevel.getEntity(pet.uuid)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public record Pet(Component name, UUID uuid) implements TooltipProvider
    {
        public static final Codec<Pet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(Pet::name), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("uuid").forGetter(Pet::uuid)).apply((Applicative)instance, Pet::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Pet> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, Pet::name, (StreamCodec)UUIDUtil.STREAM_CODEC, Pet::uuid, Pet::new);

        public static Pet of(Entity entity) {
            return new Pet(entity.getName(), entity.getUUID());
        }

        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
            tooltipAdder.accept((Component)this.name.copy().withStyle(ChatFormatting.GRAY));
        }
    }
}

