/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean isValidRepairItem(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.is(Items.COPPER_INGOT);
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.level().playSound(null, (Entity)pTarget, ModSounds.WRENCH_HIT.get(), pAttacker.getSoundSource(), 1.0f, 0.9f + pAttacker.getRandom().nextFloat() * 0.2f);
        pStack.hurtAndBreak(1, pAttacker, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            boolean shiftDown;
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            if (CompatHandler.FLAN && !FlanCompat.canPlace(player, pos)) {
                return InteractionResult.FAIL;
            }
            ItemStack itemstack = context.getItemInHand();
            Direction dir = context.getClickedFace();
            Optional<Direction> success = BlockUtil.tryRotatingBlockAndConnected(dir, shiftDown = player.isShiftKeyDown(), pos, level, context.getClickLocation(), player);
            if (success.isPresent()) {
                dir = success.get();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, itemstack);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                }
                WrenchItem.playTurningEffects(pos, shiftDown, dir, level, player);
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            level.playSound(context.getPlayer(), (Entity)player, ModSounds.WRENCH_FAIL.get(), SoundSource.PLAYERS, 1.4f, 0.8f);
        }
        return InteractionResult.FAIL;
    }

    public static void playTurningEffects(BlockPos pos, boolean shiftDown, Direction dir, Level level, Player player) {
        if (!level.isClientSide) {
            if (dir == Direction.DOWN) {
                dir = dir.getOpposite();
            }
            if (shiftDown) {
                dir = dir.getOpposite();
            }
            NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)player, (Message)new ClientBoundParticlePacket(pos.getCenter(), ClientBoundParticlePacket.Kind.WRENCH_ROTATION, dir.get3DDataValue()));
        }
        level.playSound(player, pos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        level.playSound(player, (Entity)player, ModSounds.WRENCH_ROTATE.get(), SoundSource.PLAYERS, 1.0f, 1.4f);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand pUsedHand) {
        if (entity instanceof ArmorStand || entity.getType().is(ModTags.ROTATABLE)) {
            boolean shiftDown = player.isShiftKeyDown();
            float inc = 22.5f * (float)(shiftDown ? -1 : 1);
            entity.setYRot(entity.getYRot() + inc);
            Level level = player.level();
            if (level.isClientSide) {
                WrenchItem.playTurningEffects(entity.getOnPos().above(), shiftDown, Direction.UP, level, player);
            }
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pUsedHand));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        VibeChecker.assertSameLevel(level, player);
        return super.use(level, player, usedHand);
    }
}

